/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v60.Ebi60AddressIdentifierType;
import com.helger.ebinterface.v60.Ebi60AddressType;
import com.helger.ebinterface.v60.Ebi60ContactType;
import com.helger.ebinterface.v60.Ebi60DeliveryType;
import com.helger.ebinterface.v60.Ebi60DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface60ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface60ToUBLConverter.class);

    protected AbstractEbInterface60ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi60DocumentTypeType ebi60DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi60DocumentTypeType != null) {
            switch (ebi60DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi60DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi60DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi60AddressType ebi60AddressType, @Nonnull Locale locale) {
        if (ebi60AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi60AddressType.hasAddressIdentifierEntries()) {
            Ebi60AddressIdentifierType ebi60AddressIdentifierType = ebi60AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi60AddressIdentifierType.getValue());
            if (ebi60AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi60AddressIdentifierType.getAddressIdentifierType());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi60AddressType.getStreet())) {
            addressType.setStreetName(ebi60AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi60AddressType.getPOBox())) {
            addressType.setPostbox(ebi60AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi60AddressType.getTown())) {
            addressType.setCityName(ebi60AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi60AddressType.getZIP())) {
            addressType.setPostalZone(ebi60AddressType.getZIP());
        }
        if (ebi60AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface60ToUBLConverter.createCountry(ebi60AddressType.getCountry().getCountryCode(), ebi60AddressType.getCountry().getValue(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi60AddressType ebi60AddressType, @Nullable Ebi60ContactType ebi60ContactType, @Nonnull Locale locale) {
        ContactType contactType;
        if (ebi60AddressType == null && ebi60ContactType == null) {
            return null;
        }
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        CommonsLinkedHashSet commonsLinkedHashSet2 = new CommonsLinkedHashSet();
        PartyType partyType = new PartyType();
        if (ebi60AddressType != null) {
            if (StringHelper.hasText((String)ebi60AddressType.getName())) {
                contactType = new PartyNameType();
                contactType.setName(ebi60AddressType.getName());
                partyType.addPartyName((PartyNameType)contactType);
            }
            partyType.setPostalAddress(AbstractEbInterface60ToUBLConverter.convertAddress(ebi60AddressType, locale));
            commonsLinkedHashSet.addAll((Collection)ebi60AddressType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi60AddressType.getPhone());
        }
        contactType = new ContactType();
        boolean bl = false;
        if (ebi60ContactType != null) {
            if (StringHelper.hasText((String)ebi60ContactType.getSalutation())) {
                PersonType personType = new PersonType();
                personType.setGenderCode(ebi60ContactType.getSalutation());
                partyType.addPerson(personType);
            }
            if (StringHelper.hasText((String)ebi60ContactType.getName())) {
                contactType.setName(ebi60ContactType.getName());
                bl = true;
            }
            commonsLinkedHashSet.addAll((Collection)ebi60ContactType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi60ContactType.getPhone());
        }
        if (commonsLinkedHashSet.isNotEmpty()) {
            contactType.setElectronicMail(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet));
            bl = true;
        }
        if (commonsLinkedHashSet2.isNotEmpty()) {
            contactType.setTelephone(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet2));
            bl = true;
        }
        if (bl) {
            partyType.setContact(contactType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi60DeliveryType ebi60DeliveryType, @Nonnull Locale locale) {
        if (ebi60DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi60DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi60DeliveryType.getDeliveryID());
        }
        if (ebi60DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi60DeliveryType.getDate());
        } else if (ebi60DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi60DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi60DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface60ToUBLConverter.convertAddress(ebi60DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface60ToUBLConverter.convertParty(ebi60DeliveryType.getAddress(), ebi60DeliveryType.getContact(), locale));
        return deliveryType;
    }
}

