/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterfaceToUBLConverter;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v61.Ebi61AddressIdentifierType;
import com.helger.ebinterface.v61.Ebi61AddressType;
import com.helger.ebinterface.v61.Ebi61ContactType;
import com.helger.ebinterface.v61.Ebi61DeliveryType;
import com.helger.ebinterface.v61.Ebi61DocumentTypeType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PersonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractEbInterface61ToUBLConverter
extends AbstractEbInterfaceToUBLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEbInterface61ToUBLConverter.class);

    protected AbstractEbInterface61ToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nullable
    protected static <T extends CodeType> T getTypeCode(@Nullable Ebi61DocumentTypeType ebi61DocumentTypeType, @Nonnull Supplier<T> supplier) {
        String string = null;
        if (ebi61DocumentTypeType != null) {
            switch (ebi61DocumentTypeType) {
                case INVOICE: 
                case FINAL_SETTLEMENT: 
                case SUBSEQUENT_CREDIT: 
                case SUBSEQUENT_DEBIT: {
                    string = "380";
                    break;
                }
                case CREDIT_MEMO: {
                    string = "381";
                    break;
                }
                case INVOICE_FOR_PARTIAL_DELIVERY: {
                    string = "326";
                    break;
                }
                case INVOICE_FOR_ADVANCE_PAYMENT: {
                    string = "386";
                    break;
                }
                case SELF_BILLING: {
                    string = "389";
                }
            }
        }
        if (string == null) {
            LOGGER.warn("Failed to resolve document type " + ebi61DocumentTypeType);
            return null;
        }
        CodeType codeType = (CodeType)supplier.get();
        codeType.setValue(string);
        codeType.setListID("UNCL1001");
        codeType.setName(ebi61DocumentTypeType.value());
        return (T)codeType;
    }

    @Nullable
    protected static AddressType convertAddress(@Nullable Ebi61AddressType ebi61AddressType, @Nonnull Locale locale) {
        if (ebi61AddressType == null) {
            return null;
        }
        AddressType addressType = new AddressType();
        if (ebi61AddressType.hasAddressIdentifierEntries()) {
            Ebi61AddressIdentifierType ebi61AddressIdentifierType = ebi61AddressType.getAddressIdentifierAtIndex(0);
            IDType iDType = new IDType();
            iDType.setValue(ebi61AddressIdentifierType.getValue());
            if (ebi61AddressIdentifierType.getAddressIdentifierType() != null) {
                iDType.setSchemeID(ebi61AddressIdentifierType.getAddressIdentifierType());
            }
            addressType.setID(iDType);
        }
        if (StringHelper.hasText((String)ebi61AddressType.getStreet())) {
            addressType.setStreetName(ebi61AddressType.getStreet());
        }
        if (StringHelper.hasText((String)ebi61AddressType.getPOBox())) {
            addressType.setPostbox(ebi61AddressType.getPOBox());
        }
        if (StringHelper.hasText((String)ebi61AddressType.getTown())) {
            addressType.setCityName(ebi61AddressType.getTown());
        }
        if (StringHelper.hasText((String)ebi61AddressType.getZIP())) {
            addressType.setPostalZone(ebi61AddressType.getZIP());
        }
        if (ebi61AddressType.getCountry() != null) {
            addressType.setCountry(AbstractEbInterface61ToUBLConverter.createCountry(ebi61AddressType.getCountry().getCountryCode(), ebi61AddressType.getCountry().getValue(), locale));
        }
        return addressType;
    }

    @Nullable
    protected static PartyType convertParty(@Nullable Ebi61AddressType ebi61AddressType, @Nullable Ebi61ContactType ebi61ContactType, @Nonnull Locale locale) {
        ContactType contactType;
        if (ebi61AddressType == null && ebi61ContactType == null) {
            return null;
        }
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        CommonsLinkedHashSet commonsLinkedHashSet2 = new CommonsLinkedHashSet();
        PartyType partyType = new PartyType();
        if (ebi61AddressType != null) {
            if (StringHelper.hasText((String)ebi61AddressType.getName())) {
                contactType = new PartyNameType();
                contactType.setName(ebi61AddressType.getName());
                partyType.addPartyName((PartyNameType)contactType);
            }
            partyType.setPostalAddress(AbstractEbInterface61ToUBLConverter.convertAddress(ebi61AddressType, locale));
            commonsLinkedHashSet.addAll((Collection)ebi61AddressType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi61AddressType.getPhone());
        }
        contactType = new ContactType();
        boolean bl = false;
        if (ebi61ContactType != null) {
            if (StringHelper.hasText((String)ebi61ContactType.getSalutation())) {
                PersonType personType = new PersonType();
                personType.setGenderCode(ebi61ContactType.getSalutation());
                partyType.addPerson(personType);
            }
            if (StringHelper.hasText((String)ebi61ContactType.getName())) {
                contactType.setName(ebi61ContactType.getName());
                bl = true;
            }
            commonsLinkedHashSet.addAll((Collection)ebi61ContactType.getEmail());
            commonsLinkedHashSet2.addAll((Collection)ebi61ContactType.getPhone());
        }
        if (commonsLinkedHashSet.isNotEmpty()) {
            contactType.setElectronicMail(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet));
            bl = true;
        }
        if (commonsLinkedHashSet2.isNotEmpty()) {
            contactType.setTelephone(StringHelper.getImploded((char)' ', (Iterable)commonsLinkedHashSet2));
            bl = true;
        }
        if (bl) {
            partyType.setContact(contactType);
        }
        return partyType;
    }

    @Nullable
    protected static DeliveryType convertDelivery(@Nullable Ebi61DeliveryType ebi61DeliveryType, @Nonnull Locale locale) {
        if (ebi61DeliveryType == null) {
            return null;
        }
        DeliveryType deliveryType = new DeliveryType();
        if (ebi61DeliveryType.getDeliveryID() != null) {
            deliveryType.setID(ebi61DeliveryType.getDeliveryID());
        }
        if (ebi61DeliveryType.getDate() != null) {
            deliveryType.setActualDeliveryDate(ebi61DeliveryType.getDate());
        } else if (ebi61DeliveryType.getPeriod() != null) {
            PeriodType periodType = new PeriodType();
            periodType.setStartDate(ebi61DeliveryType.getPeriod().getFromDate());
            periodType.setEndDate(ebi61DeliveryType.getPeriod().getToDate());
            deliveryType.setRequestedDeliveryPeriod(periodType);
        }
        deliveryType.setDeliveryAddress(AbstractEbInterface61ToUBLConverter.convertAddress(ebi61DeliveryType.getAddress(), locale));
        deliveryType.setDeliveryParty(AbstractEbInterface61ToUBLConverter.convertParty(ebi61DeliveryType.getAddress(), ebi61DeliveryType.getContact(), locale));
        return deliveryType;
    }
}

