/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.AbstractConverter;
import at.austriapro.ebinterface.ubl.helper.MultilingualCountryCache;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.codelist.ETaxCategoryCode;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;

@Immutable
public abstract class AbstractEbInterfaceToUBLConverter
extends AbstractConverter {
    public static final String CURRENCY_LIST_AGENCY_ID = "6";
    public static final String CURRENCY_LIST_ID = "ISO 4217 Alpha";

    protected AbstractEbInterfaceToUBLConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    @Nonnull
    protected static final TaxSchemeType createTaxScheme(@Nonnull String string) {
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        IDType iDType = taxSchemeType.setID(string);
        iDType.setSchemeAgencyID(CURRENCY_LIST_AGENCY_ID);
        iDType.setSchemeID("UN/ECE 5153");
        return taxSchemeType;
    }

    @Nonnull
    protected static final TaxSchemeType createTaxSchemeVAT() {
        return AbstractEbInterfaceToUBLConverter.createTaxScheme("VAT");
    }

    @Nonnull
    protected static final TaxCategoryType createTaxCategory(@Nonnull String string) {
        TaxCategoryType taxCategoryType = new TaxCategoryType();
        IDType iDType = taxCategoryType.setID(string);
        iDType.setSchemeAgencyID(CURRENCY_LIST_AGENCY_ID);
        iDType.setSchemeID("UN/ECE 5153");
        return taxCategoryType;
    }

    @Nonnull
    protected static final TaxCategoryType createTaxCategoryVAT(@Nonnull String string) {
        TaxCategoryType taxCategoryType = AbstractEbInterfaceToUBLConverter.createTaxCategory(string);
        taxCategoryType.setTaxScheme(AbstractEbInterfaceToUBLConverter.createTaxSchemeVAT());
        return taxCategoryType;
    }

    @Nonnull
    protected static final TaxCategoryType createTaxCategoryOther() {
        TaxCategoryType taxCategoryType = AbstractEbInterfaceToUBLConverter.createTaxCategory(ETaxCategoryCode.O.getID());
        taxCategoryType.setTaxScheme(AbstractEbInterfaceToUBLConverter.createTaxScheme("OTH"));
        return taxCategoryType;
    }

    @Nonnull
    protected static final ItemPropertyType createItemProperty(@Nullable String string, @Nullable String string2) {
        ItemPropertyType itemPropertyType = new ItemPropertyType();
        itemPropertyType.setName(string);
        itemPropertyType.setValue(string2);
        return itemPropertyType;
    }

    @Nullable
    protected static final CountryType createCountry(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        String string3;
        Locale locale2;
        String string4;
        if (StringHelper.hasNoText((String)string)) {
            if (StringHelper.hasNoText((String)string2)) {
                return null;
            }
            string4 = MultilingualCountryCache.getRealCountryCode(string2);
            locale2 = CountryCache.getInstance().getCountry(string4);
            string3 = locale2 != null ? locale2.getDisplayCountry(locale) : string2;
        } else if (StringHelper.hasNoText((String)string2)) {
            string4 = string;
            locale2 = CountryCache.getInstance().getCountry(string4);
            string3 = locale2 != null ? locale2.getDisplayCountry(locale) : string;
        } else {
            string4 = string;
            string3 = string2;
        }
        locale2 = new CountryType();
        locale2.setIdentificationCode(string4);
        locale2.setName(string3);
        return locale2;
    }
}

