/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterface40ToUBLConverter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v40.Ebi40AccountType;
import com.helger.ebinterface.v40.Ebi40ClassificationType;
import com.helger.ebinterface.v40.Ebi40DirectDebitType;
import com.helger.ebinterface.v40.Ebi40InvoiceType;
import com.helger.ebinterface.v40.Ebi40NoPaymentType;
import com.helger.ebinterface.v40.Ebi40OtherTaxType;
import com.helger.ebinterface.v40.Ebi40PaymentConditionsType;
import com.helger.ebinterface.v40.Ebi40PaymentMethodType;
import com.helger.ebinterface.v40.Ebi40ReductionAndSurchargeType;
import com.helger.ebinterface.v40.Ebi40UniversalBankTransactionType;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialInstitutionType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

public class EbInterface40ToInvoiceConverter
extends AbstractEbInterface40ToUBLConverter {
    public EbInterface40ToInvoiceConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    private static void _convertPayment(@Nonnull Ebi40InvoiceType ebi40InvoiceType, @Nonnull InvoiceType invoiceType) {
        BranchType branchType;
        FinancialAccountType financialAccountType;
        Object object;
        PaymentTermsType paymentTermsType;
        Ebi40PaymentMethodType ebi40PaymentMethodType = ebi40InvoiceType.getPaymentMethod();
        Ebi40PaymentConditionsType ebi40PaymentConditionsType = ebi40InvoiceType.getPaymentConditions();
        if (ebi40PaymentMethodType != null && !(ebi40PaymentMethodType instanceof Ebi40NoPaymentType)) {
            if (ebi40PaymentMethodType instanceof Ebi40DirectDebitType) {
                paymentTermsType = new PaymentMeansType();
                paymentTermsType.setPaymentMeansCode("49");
                if (ebi40PaymentConditionsType != null) {
                    paymentTermsType.setPaymentDueDate(ebi40PaymentConditionsType.getDueDate());
                }
                if (StringHelper.hasText((String)ebi40PaymentMethodType.getComment())) {
                    paymentTermsType.addInstructionNote(new InstructionNoteType(ebi40PaymentMethodType.getComment()));
                }
                invoiceType.addPaymentMeans((PaymentMeansType)paymentTermsType);
            } else if (ebi40PaymentMethodType instanceof Ebi40UniversalBankTransactionType) {
                paymentTermsType = (Ebi40UniversalBankTransactionType)ebi40PaymentMethodType;
                object = new PaymentMeansType();
                object.setPaymentMeansCode("30");
                object.setPaymentChannelCode("IBAN");
                if (paymentTermsType.hasBeneficiaryAccountEntries()) {
                    Ebi40AccountType ebi40AccountType = paymentTermsType.getBeneficiaryAccountAtIndex(0);
                    financialAccountType = new FinancialAccountType();
                    branchType = new BranchType();
                    FinancialInstitutionType financialInstitutionType = new FinancialInstitutionType();
                    IDType iDType = new IDType();
                    if (StringHelper.hasText((String)ebi40AccountType.getBIC())) {
                        iDType.setValue(ebi40AccountType.getBIC());
                        iDType.setSchemeID("BIC");
                    } else if (ebi40AccountType.getBankCode() != null) {
                        iDType.setValue(ebi40AccountType.getBankCode().getValue().toString());
                        iDType.setSchemeID("local");
                    } else if (StringHelper.hasText((String)ebi40AccountType.getBankName())) {
                        iDType.setValue(ebi40AccountType.getBankName());
                        iDType.setSchemeID("name");
                    }
                    if (StringHelper.hasText((String)iDType.getValue())) {
                        financialInstitutionType.setID(iDType);
                    }
                    if (financialInstitutionType.getID() != null) {
                        branchType.setFinancialInstitution(financialInstitutionType);
                    }
                    iDType = new IDType();
                    if (StringHelper.hasText((String)ebi40AccountType.getIBAN())) {
                        iDType.setValue(ebi40AccountType.getIBAN());
                        iDType.setSchemeID("IBAN");
                    } else if (StringHelper.hasText((String)ebi40AccountType.getBankAccountNr())) {
                        iDType.setValue(ebi40AccountType.getBankAccountNr());
                        iDType.setSchemeID("local");
                    }
                    if (StringHelper.hasText((String)iDType.getValue())) {
                        financialAccountType.setID(iDType);
                    }
                    financialAccountType.setName(ebi40AccountType.getBankAccountOwner());
                    if (branchType.getFinancialInstitution() != null) {
                        financialAccountType.setFinancialInstitutionBranch(branchType);
                    }
                    object.setPayeeFinancialAccount(financialAccountType);
                }
                if (paymentTermsType.getPaymentReference() != null) {
                    object.setInstructionID(new InstructionIDType(paymentTermsType.getPaymentReference().getValue()));
                }
                if (ebi40PaymentConditionsType != null) {
                    object.setPaymentDueDate(ebi40PaymentConditionsType.getDueDate());
                }
                if (StringHelper.hasText((String)ebi40PaymentMethodType.getComment())) {
                    object.addInstructionNote(new InstructionNoteType(ebi40PaymentMethodType.getComment()));
                }
                invoiceType.addPaymentMeans((PaymentMeansType)object);
            } else {
                throw new IllegalStateException("Unsupported payment method present!");
            }
        }
        if (ebi40PaymentConditionsType != null) {
            paymentTermsType = new PaymentTermsType();
            paymentTermsType.setPaymentDueDate(ebi40PaymentConditionsType.getDueDate());
            if (ebi40PaymentConditionsType.getMinimumPayment() != null) {
                object = ebi40PaymentConditionsType.getMinimumPayment().divide(ebi40InvoiceType.getTotalGrossAmount(), 4, ROUNDING_MODE).multiply(CGlobal.BIGDEC_100);
                paymentTermsType.setPaymentPercent((BigDecimal)object);
            }
            if (StringHelper.hasText((String)ebi40PaymentConditionsType.getComment())) {
                paymentTermsType.addNote(new NoteType(ebi40PaymentConditionsType.getComment()));
            }
            invoiceType.addPaymentTerms(paymentTermsType);
            paymentTermsType = ebi40InvoiceType.getInvoiceCurrency() != null ? ebi40InvoiceType.getInvoiceCurrency().value() : null;
            for (Ebi40AccountType ebi40AccountType : ebi40PaymentConditionsType.getDiscount()) {
                financialAccountType = new PaymentTermsType();
                branchType = new PeriodType();
                branchType.setEndDate(ebi40AccountType.getPaymentDate());
                financialAccountType.setSettlementPeriod((PeriodType)branchType);
                if (ebi40AccountType.getBaseAmount() != null) {
                    financialAccountType.setAmount(ebi40AccountType.getBaseAmount()).setCurrencyID((String)paymentTermsType);
                }
                financialAccountType.setSettlementDiscountPercent(ebi40AccountType.getPercentage());
                if (ebi40AccountType.getAmount() != null) {
                    financialAccountType.setSettlementDiscountAmount(ebi40AccountType.getAmount()).setCurrencyID((String)paymentTermsType);
                }
                invoiceType.addPaymentTerms((PaymentTermsType)financialAccountType);
            }
        }
    }

    @Nonnull
    public InvoiceType convertInvoice(@Nonnull Ebi40InvoiceType ebi40InvoiceType) {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        Object object52;
        Object object6;
        Object object72;
        Object object8;
        PartyType partyType;
        SupplierPartyType supplierPartyType;
        ValueEnforcer.notNull((Object)ebi40InvoiceType, (String)"ebInterfaceDocument");
        String string = ebi40InvoiceType.getInvoiceCurrency() != null ? ebi40InvoiceType.getInvoiceCurrency().value() : null;
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setUBLVersionID("2.1");
        invoiceType.setInvoiceTypeCode(EbInterface40ToInvoiceConverter.getTypeCode(ebi40InvoiceType.getDocumentType(), InvoiceTypeCodeType::new));
        DocumentCurrencyCodeType documentCurrencyCodeType = invoiceType.setDocumentCurrencyCode(string);
        documentCurrencyCodeType.setListAgencyID("6");
        documentCurrencyCodeType.setListID("ISO 4217 Alpha");
        invoiceType.setID(ebi40InvoiceType.getInvoiceNumber());
        invoiceType.setIssueDate(ebi40InvoiceType.getInvoiceDate());
        Object object9 = EbInterface40ToInvoiceConverter.convertDelivery(ebi40InvoiceType.getDelivery(), this.m_aContentLocale);
        if (object9 != null) {
            if (invoiceType.getInvoicePeriodCount() == 0 && object9.getRequestedDeliveryPeriod() != null) {
                invoiceType.addInvoicePeriod(object9.getRequestedDeliveryPeriod());
            }
            invoiceType.addDelivery((DeliveryType)object9);
        }
        if ((object9 = ebi40InvoiceType.getBiller()) != null) {
            supplierPartyType = new SupplierPartyType();
            partyType = EbInterface40ToInvoiceConverter.convertParty(object9.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object9.getVATIdentificationNumber())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                object8 = new PartyTaxSchemeType();
                object8.setTaxScheme(EbInterface40ToInvoiceConverter.createTaxSchemeVAT());
                object72 = object8.setCompanyID(object9.getVATIdentificationNumber());
                object72.setSchemeID("VAT");
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object8);
            }
            if (StringHelper.hasText((String)object9.getInvoiceRecipientsBillerID())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                supplierPartyType.setCustomerAssignedAccountID(object9.getInvoiceRecipientsBillerID());
                object8 = new PartyIdentificationType();
                object8.setID(object9.getInvoiceRecipientsBillerID());
                partyType.addPartyIdentification((PartyIdentificationType)object8);
            }
            supplierPartyType.setParty(partyType);
            for (Object object72 : object9.getFurtherIdentification()) {
                object6 = new DocumentReferenceType();
                object52 = new IDType();
                object52.setValue(object72.getValue());
                object52.setSchemeID(object72.getIdentificationType());
                object6.setID((IDType)object52);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object6);
            }
            invoiceType.setAccountingSupplierParty(supplierPartyType);
        }
        if ((object9 = ebi40InvoiceType.getInvoiceRecipient()) != null) {
            supplierPartyType = new CustomerPartyType();
            partyType = EbInterface40ToInvoiceConverter.convertParty(object9.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object9.getVATIdentificationNumber())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                object8 = new PartyTaxSchemeType();
                object8.setTaxScheme(EbInterface40ToInvoiceConverter.createTaxSchemeVAT());
                object72 = object8.setCompanyID(object9.getVATIdentificationNumber());
                object72.setSchemeID("VAT");
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object8);
            }
            if (StringHelper.hasText((String)object9.getBillersInvoiceRecipientID())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                supplierPartyType.setSupplierAssignedAccountID(object9.getBillersInvoiceRecipientID());
                object8 = new PartyIdentificationType();
                object8.setID(object9.getBillersInvoiceRecipientID());
                partyType.addPartyIdentification((PartyIdentificationType)object8);
            }
            supplierPartyType.setParty(partyType);
            object8 = object9.getOrderReference();
            if (object8 != null) {
                object72 = new OrderReferenceType();
                object72.setID(object8.getOrderID());
                if (object8.getReferenceDate() != null) {
                    object72.setIssueDate(object8.getReferenceDate());
                }
                invoiceType.setOrderReference((OrderReferenceType)object72);
            }
            invoiceType.setAccountingCustomerParty((CustomerPartyType)supplierPartyType);
        }
        if ((object9 = ebi40InvoiceType.getOrderingParty()) != null) {
            supplierPartyType = new CustomerPartyType();
            partyType = EbInterface40ToInvoiceConverter.convertParty(object9.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object9.getVATIdentificationNumber())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                object8 = new PartyTaxSchemeType();
                object8.setTaxScheme(EbInterface40ToInvoiceConverter.createTaxSchemeVAT());
                object72 = object8.setCompanyID(object9.getVATIdentificationNumber());
                object72.setSchemeID("VAT");
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object8);
            }
            if (StringHelper.hasText((String)object9.getBillersOrderingPartyID())) {
                if (partyType == null) {
                    partyType = new PartyType();
                }
                supplierPartyType.setSupplierAssignedAccountID(object9.getBillersOrderingPartyID());
                object8 = new PartyIdentificationType();
                object8.setID(object9.getBillersOrderingPartyID());
                partyType.addPartyIdentification((PartyIdentificationType)object8);
            }
            supplierPartyType.setParty(partyType);
            invoiceType.setBuyerCustomerParty((CustomerPartyType)supplierPartyType);
        }
        object9 = BigDecimal.ZERO;
        supplierPartyType = ebi40InvoiceType.getDetails();
        int n = 1;
        for (Object object72 : supplierPartyType.getItemList()) {
            for (Object object52 : object72.getListLineItem()) {
                PartyIdentificationType partyIdentificationType;
                PartyType partyType2;
                Object object102;
                object42 = new InvoiceLineType();
                object42.setID(object52.getPositionNumber() != null ? object52.getPositionNumber().toString() : Integer.toString(n));
                object32 = StringHelper.trim((String)object52.getQuantity().getUnit());
                if (object32 == null) {
                    object32 = "C62";
                }
                object42.setInvoicedQuantity(object52.getQuantity().getValue()).setUnitCode((String)object32);
                object42.setLineExtensionAmount(object52.getLineItemAmount()).setCurrencyID(string);
                PriceType priceType = new PriceType();
                priceType.setPriceAmount(object52.getUnitPrice()).setCurrencyID(string);
                object42.setPrice(priceType);
                if (object52.getDelivery() != null) {
                    object42.addDelivery(EbInterface40ToInvoiceConverter.convertDelivery(object52.getDelivery(), this.m_aContentLocale));
                }
                object2 = new ItemType();
                for (Iterator iterator : object52.getDescription()) {
                    object2.addDescription(new DescriptionType((String)((Object)iterator)));
                }
                object2.setPackSizeNumeric(BigDecimal.ONE);
                object = EbInterface40ToInvoiceConverter.createTaxCategoryVAT("S");
                object.setPercent(object52.getTaxRateValue());
                if (StringHelper.hasText((String)object52.getTaxRate().getTaxCode())) {
                    object.setName(object52.getTaxRate().getTaxCode());
                }
                object2.addClassifiedTaxCategory((TaxCategoryType)object);
                if (object52.getReductionAndSurchargeListLineItemDetails() != null) {
                    for (Iterator iterator : object52.getReductionAndSurchargeListLineItemDetails().getReductionListLineItem()) {
                        object102 = new AllowanceChargeType();
                        object102.setChargeIndicator(false);
                        object102.setBaseAmount(iterator.getBaseAmount()).setCurrencyID(string);
                        if (iterator.getPercentage() != null) {
                            object102.setMultiplierFactorNumeric(iterator.getPercentage().divide(CGlobal.BIGDEC_100));
                        }
                        if (iterator.getAmount() != null) {
                            object102.setAmount(iterator.getAmount()).setCurrencyID(string);
                        } else if (iterator.getPercentage() != null) {
                            object102.setAmount(MathHelper.getPercentValue((BigDecimal)iterator.getBaseAmount(), (BigDecimal)iterator.getPercentage())).setCurrencyID(string);
                        }
                        if (object102.getAmount() == null) continue;
                        object42.addAllowanceCharge((AllowanceChargeType)object102);
                    }
                    for (Iterator iterator : object52.getReductionAndSurchargeListLineItemDetails().getSurchargeListLineItem()) {
                        object102 = new AllowanceChargeType();
                        object102.setChargeIndicator(true);
                        object102.setBaseAmount(iterator.getBaseAmount()).setCurrencyID(string);
                        if (iterator.getPercentage() != null) {
                            object102.setMultiplierFactorNumeric(iterator.getPercentage().divide(CGlobal.BIGDEC_100));
                        }
                        if (iterator.getAmount() != null) {
                            object102.setAmount(iterator.getAmount()).setCurrencyID(string);
                        } else if (iterator.getPercentage() != null) {
                            object102.setAmount(MathHelper.getPercentValue((BigDecimal)iterator.getBaseAmount(), (BigDecimal)iterator.getPercentage())).setCurrencyID(string);
                        }
                        if (object102.getAmount() == null) continue;
                        object42.addAllowanceCharge((AllowanceChargeType)object102);
                    }
                }
                for (Iterator iterator : object52.getArticleNumber()) {
                    object102 = new ItemIdentificationType();
                    object102.setID(iterator.getContent());
                    if (iterator.getArticleNumberType() != null) {
                        partyType2 = new PartyType();
                        partyIdentificationType = new PartyIdentificationType();
                        partyIdentificationType.setID(iterator.getArticleNumberType().value());
                        partyType2.addPartyIdentification(partyIdentificationType);
                        object102.setIssuerParty(partyType2);
                    }
                    object2.addManufacturersItemIdentification(object102);
                }
                object = object52.getAdditionalInformation();
                if (object != null) {
                    Iterator iterator;
                    for (Object object102 : object.getSerialNumber()) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("SerialNumber", (String)object102));
                    }
                    for (Object object102 : object.getSerialNumber()) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("ChargeNumber", (String)object102));
                    }
                    iterator = object.getClassification().iterator();
                    while (iterator.hasNext()) {
                        object102 = (Ebi40ClassificationType)iterator.next();
                        partyType2 = new CommodityClassificationType();
                        partyIdentificationType = new ItemClassificationCodeType();
                        partyIdentificationType.setValue(object102.getValue());
                        partyIdentificationType.setName(object102.getClassificationSchema());
                        partyType2.setItemClassificationCode((ItemClassificationCodeType)partyIdentificationType);
                        object2.addCommodityClassification((CommodityClassificationType)partyType2);
                    }
                    if (object.getAlternativeQuantity() != null) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("AlternativeQuantity", object.getAlternativeQuantity().getValue().toString()));
                    }
                    if (object.getSize() != null) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("Size", object.getSize()));
                    }
                    if (object.getWeight() != null) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("Weight", object.getWeight().getValue().toString()));
                    }
                    if (object.getBoxes() != null) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("Boxes", object.getBoxes().toString()));
                    }
                    if (object.getColor() != null) {
                        object2.addAdditionalItemProperty(EbInterface40ToInvoiceConverter.createItemProperty("Color", object.getColor()));
                    }
                }
                object42.setItem((ItemType)object2);
                object2 = object52.getInvoiceRecipientsOrderReference();
                if (object2 != null) {
                    object = new OrderLineReferenceType();
                    boolean bl = false;
                    object102 = new OrderReferenceType();
                    boolean bl2 = false;
                    if (object2.getOrderID() != null) {
                        object102.setID(object2.getOrderID());
                        bl2 = true;
                    }
                    if (bl2) {
                        object.setOrderReference((OrderReferenceType)object102);
                        bl = true;
                    }
                    if (object2.getOrderPositionNumber() != null) {
                        object.setLineID(object2.getOrderPositionNumber());
                        bl = true;
                    }
                    if (bl) {
                        object42.addOrderLineReference((OrderLineReferenceType)object);
                    }
                }
                invoiceType.addInvoiceLine((InvoiceLineType)object42);
                object9 = ((BigDecimal)object9).add(object52.getLineItemAmount());
                ++n;
            }
        }
        EbInterface40ToInvoiceConverter._convertPayment(ebi40InvoiceType, invoiceType);
        object8 = BigDecimal.ZERO;
        object72 = BigDecimal.ZERO;
        if (ebi40InvoiceType.getReductionAndSurchargeDetails() != null) {
            for (Object object52 : ebi40InvoiceType.getReductionAndSurchargeDetails().getReductionOrSurcharge()) {
                object42 = (Ebi40ReductionAndSurchargeType)object52.getValue();
                object32 = new AllowanceChargeType();
                boolean bl = object52.getName().getLocalPart().equals("Reduction");
                object32.setChargeIndicator(!bl);
                object32.setBaseAmount(object42.getBaseAmount()).setCurrencyID(string);
                if (object42.getPercentage() != null) {
                    object32.setMultiplierFactorNumeric(object42.getPercentage().divide(CGlobal.BIGDEC_100));
                }
                object2 = null;
                if (object42.getAmount() != null) {
                    object2 = object42.getAmount();
                } else if (object42.getPercentage() != null) {
                    object2 = MathHelper.getPercentValue((BigDecimal)object42.getBaseAmount(), (BigDecimal)object42.getPercentage());
                }
                object = object42.getTaxRate();
                TaxCategoryType taxCategoryType = EbInterface40ToInvoiceConverter.createTaxCategoryVAT("S");
                taxCategoryType.setPercent(object.getValue());
                object32.addTaxCategory(taxCategoryType);
                if (object2 != null) {
                    object32.setAmount((BigDecimal)object2).setCurrencyID(string);
                    if (object32.isChargeIndicatorValue(false)) {
                        object8 = ((BigDecimal)object8).add((BigDecimal)object2);
                    } else {
                        object72 = ((BigDecimal)object72).add((BigDecimal)object2);
                    }
                }
                invoiceType.addAllowanceCharge((AllowanceChargeType)object32);
            }
        }
        object6 = new TaxTotalType();
        object52 = BigDecimal.ZERO;
        for (Object object32 : ebi40InvoiceType.getTax().getVAT().getItem()) {
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            taxSubtotalType.setTaxableAmount(object32.getTaxedAmount()).setCurrencyID(string);
            taxSubtotalType.setTaxAmount(object32.getAmount()).setCurrencyID(string);
            object2 = EbInterface40ToInvoiceConverter.createTaxCategoryVAT("S");
            object2.setPercent(object32.getTaxRateValue());
            if (StringHelper.hasText((String)object32.getTaxRate().getTaxCode())) {
                object2.setName(object32.getTaxRate().getTaxCode());
            }
            taxSubtotalType.setTaxCategory((TaxCategoryType)object2);
            object6.addTaxSubtotal(taxSubtotalType);
            object52 = ((BigDecimal)object52).add(object32.getAmount());
        }
        object42 = ebi40InvoiceType.getTax().getTaxExtension();
        if (object42 != null) {
            object32 = new TaxSubtotalType();
            object32.setTaxAmount(BigDecimal.ZERO).setCurrencyID(string);
            TaxCategoryType taxCategoryType = EbInterface40ToInvoiceConverter.createTaxCategoryVAT("E");
            taxCategoryType.setPercent(BigDecimal.ZERO);
            object32.setTaxCategory(taxCategoryType);
            object6.addTaxSubtotal((TaxSubtotalType)object32);
        }
        for (Ebi40OtherTaxType ebi40OtherTaxType : ebi40InvoiceType.getTax().getOtherTax()) {
            object2 = new TaxSubtotalType();
            object2.setTaxAmount(ebi40OtherTaxType.getAmount()).setCurrencyID(string);
            object = EbInterface40ToInvoiceConverter.createTaxCategoryOther();
            if (StringHelper.hasText((String)ebi40OtherTaxType.getComment())) {
                object.getTaxScheme().setName(ebi40OtherTaxType.getComment());
            }
            object2.setTaxCategory((TaxCategoryType)object);
            object6.addTaxSubtotal(object2);
            object52 = ((BigDecimal)object52).add(ebi40OtherTaxType.getAmount());
        }
        object6.setTaxAmount((BigDecimal)object52).setCurrencyID(string);
        invoiceType.addTaxTotal((TaxTotalType)object6);
        object6 = BigDecimal.ZERO;
        for (Object object42 : invoiceType.getInvoiceLine()) {
            object6 = ((BigDecimal)object6).add(object42.getLineExtensionAmountValue());
        }
        object52 = new MonetaryTotalType();
        object52.setLineExtensionAmount((BigDecimal)object6).setCurrencyID(string);
        object52.setAllowanceTotalAmount((BigDecimal)object72).setCurrencyID(string);
        object52.setChargeTotalAmount((BigDecimal)object8).setCurrencyID(string);
        object52.setTaxExclusiveAmount((BigDecimal)object9).setCurrencyID(string);
        object52.setTaxInclusiveAmount(ebi40InvoiceType.getTotalGrossAmount()).setCurrencyID(string);
        object52.setPayableAmount(ebi40InvoiceType.getTotalGrossAmount()).setCurrencyID(string);
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object52);
        return invoiceType;
    }
}

