/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterface43ToUBLConverter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v43.Ebi43AccountType;
import com.helger.ebinterface.v43.Ebi43ClassificationType;
import com.helger.ebinterface.v43.Ebi43InvoiceType;
import com.helger.ebinterface.v43.Ebi43OtherVATableTaxBaseType;
import com.helger.ebinterface.v43.Ebi43OtherVATableTaxType;
import com.helger.ebinterface.v43.Ebi43PaymentConditionsType;
import com.helger.ebinterface.v43.Ebi43PaymentMethodType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v43.Ebi43ReductionAndSurchargeType;
import com.helger.ebinterface.v43.Ebi43SEPADirectDebitType;
import com.helger.ebinterface.v43.Ebi43UniversalBankTransactionType;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialInstitutionType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AdditionalAccountIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

public class EbInterface43ToInvoiceConverter
extends AbstractEbInterface43ToUBLConverter {
    public EbInterface43ToInvoiceConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    private static void _convertPayment(@Nonnull Ebi43InvoiceType ebi43InvoiceType, @Nonnull InvoiceType invoiceType) {
        Ebi43UniversalBankTransactionType ebi43UniversalBankTransactionType;
        Ebi43SEPADirectDebitType ebi43SEPADirectDebitType;
        Object object3;
        Object object2;
        Ebi43PaymentMethodType ebi43PaymentMethodType = ebi43InvoiceType.getPaymentMethod();
        Ebi43PaymentConditionsType ebi43PaymentConditionsType = ebi43InvoiceType.getPaymentConditions();
        if (ebi43PaymentMethodType != null && (object2 = ebi43PaymentMethodType.getNoPayment()) == null) {
            object3 = ebi43PaymentMethodType.getDirectDebit();
            if (object3 != null) {
                ebi43SEPADirectDebitType = new PaymentMeansType();
                ebi43SEPADirectDebitType.setPaymentMeansCode("49");
                if (ebi43PaymentConditionsType != null) {
                    ebi43SEPADirectDebitType.setPaymentDueDate(ebi43PaymentConditionsType.getDueDate());
                }
                if (StringHelper.hasText((String)ebi43PaymentMethodType.getComment())) {
                    ebi43SEPADirectDebitType.addInstructionNote(new InstructionNoteType(ebi43PaymentMethodType.getComment()));
                }
                invoiceType.addPaymentMeans((PaymentMeansType)ebi43SEPADirectDebitType);
            } else {
                ebi43SEPADirectDebitType = ebi43PaymentMethodType.getSEPADirectDebit();
                if (ebi43SEPADirectDebitType != null) {
                    ebi43UniversalBankTransactionType = new PaymentMeansType();
                    ebi43UniversalBankTransactionType.setPaymentMeansCode("59");
                    if (ebi43PaymentConditionsType != null) {
                        ebi43UniversalBankTransactionType.setPaymentDueDate(ebi43PaymentConditionsType.getDueDate());
                    }
                    if (StringHelper.hasText((String)ebi43PaymentMethodType.getComment())) {
                        ebi43UniversalBankTransactionType.addInstructionNote(new InstructionNoteType(ebi43PaymentMethodType.getComment()));
                    }
                    invoiceType.addPaymentMeans((PaymentMeansType)ebi43UniversalBankTransactionType);
                } else {
                    ebi43UniversalBankTransactionType = ebi43PaymentMethodType.getUniversalBankTransaction();
                    if (ebi43UniversalBankTransactionType != null) {
                        PaymentMeansType paymentMeansType = new PaymentMeansType();
                        paymentMeansType.setPaymentMeansCode("30");
                        paymentMeansType.setPaymentChannelCode("IBAN");
                        if (ebi43UniversalBankTransactionType.hasBeneficiaryAccountEntries()) {
                            Ebi43AccountType ebi43AccountType = ebi43UniversalBankTransactionType.getBeneficiaryAccountAtIndex(0);
                            FinancialAccountType financialAccountType = new FinancialAccountType();
                            BranchType branchType = new BranchType();
                            FinancialInstitutionType financialInstitutionType = new FinancialInstitutionType();
                            IDType iDType = new IDType();
                            if (StringHelper.hasText((String)ebi43AccountType.getBIC())) {
                                iDType.setValue(ebi43AccountType.getBIC());
                                iDType.setSchemeID("BIC");
                            } else if (ebi43AccountType.getBankCode() != null) {
                                iDType.setValue(ebi43AccountType.getBankCode().getValue().toString());
                                iDType.setSchemeID(ebi43AccountType.getBankCode().getBankCodeType());
                            } else if (StringHelper.hasText((String)ebi43AccountType.getBankName())) {
                                iDType.setValue(ebi43AccountType.getBankName());
                                iDType.setSchemeID("name");
                            }
                            if (StringHelper.hasText((String)iDType.getValue())) {
                                financialInstitutionType.setID(iDType);
                            }
                            if (financialInstitutionType.getID() != null) {
                                branchType.setFinancialInstitution(financialInstitutionType);
                            }
                            iDType = new IDType();
                            if (StringHelper.hasText((String)ebi43AccountType.getIBAN())) {
                                iDType.setValue(ebi43AccountType.getIBAN());
                                iDType.setSchemeID("IBAN");
                            } else if (StringHelper.hasText((String)ebi43AccountType.getBankAccountNr())) {
                                iDType.setValue(ebi43AccountType.getBankAccountNr());
                                iDType.setSchemeID("local");
                            }
                            if (StringHelper.hasText((String)iDType.getValue())) {
                                financialAccountType.setID(iDType);
                            }
                            financialAccountType.setName(ebi43AccountType.getBankAccountOwner());
                            if (branchType.getFinancialInstitution() != null) {
                                financialAccountType.setFinancialInstitutionBranch(branchType);
                            }
                            paymentMeansType.setPayeeFinancialAccount(financialAccountType);
                        }
                        if (ebi43UniversalBankTransactionType.getPaymentReference() != null) {
                            paymentMeansType.setInstructionID(new InstructionIDType(ebi43UniversalBankTransactionType.getPaymentReference().getValue()));
                        }
                        if (ebi43PaymentConditionsType != null) {
                            paymentMeansType.setPaymentDueDate(ebi43PaymentConditionsType.getDueDate());
                        }
                        if (StringHelper.hasText((String)ebi43PaymentMethodType.getComment())) {
                            paymentMeansType.addInstructionNote(new InstructionNoteType(ebi43PaymentMethodType.getComment()));
                        }
                        invoiceType.addPaymentMeans(paymentMeansType);
                    } else {
                        throw new IllegalStateException("Unsupported payment method present!");
                    }
                }
            }
        }
        if (ebi43PaymentConditionsType != null) {
            object2 = new PaymentTermsType();
            object2.setPaymentDueDate(ebi43PaymentConditionsType.getDueDate());
            if (ebi43PaymentConditionsType.getMinimumPayment() != null) {
                object3 = ebi43PaymentConditionsType.getMinimumPayment().divide(ebi43InvoiceType.getPayableAmount(), 4, ROUNDING_MODE).multiply(CGlobal.BIGDEC_100);
                object2.setPaymentPercent((BigDecimal)object3);
            }
            if (StringHelper.hasText((String)ebi43PaymentConditionsType.getComment())) {
                object2.addNote(new NoteType(ebi43PaymentConditionsType.getComment()));
            }
            invoiceType.addPaymentTerms((PaymentTermsType)object2);
            for (Object object3 : ebi43PaymentConditionsType.getDiscount()) {
                ebi43SEPADirectDebitType = new PaymentTermsType();
                ebi43UniversalBankTransactionType = new PeriodType();
                ebi43UniversalBankTransactionType.setEndDate(object3.getPaymentDate());
                ebi43SEPADirectDebitType.setSettlementPeriod((PeriodType)ebi43UniversalBankTransactionType);
                if (object3.getBaseAmount() != null) {
                    ebi43SEPADirectDebitType.setAmount(object3.getBaseAmount()).setCurrencyID(ebi43InvoiceType.getInvoiceCurrency());
                }
                ebi43SEPADirectDebitType.setSettlementDiscountPercent(object3.getPercentage());
                if (object3.getAmount() != null) {
                    ebi43SEPADirectDebitType.setSettlementDiscountAmount(object3.getAmount()).setCurrencyID(ebi43InvoiceType.getInvoiceCurrency());
                }
                invoiceType.addPaymentTerms((PaymentTermsType)ebi43SEPADirectDebitType);
            }
        }
    }

    @Nonnull
    public InvoiceType convertInvoice(@Nonnull Ebi43InvoiceType ebi43InvoiceType) {
        Object object9;
        Object object2;
        Object object3;
        AllowanceChargeType allowanceChargeType3;
        PriceType priceType2;
        Object object42;
        Object object52;
        Object object6;
        CompanyIDType companyIDType2;
        Object object7;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType22;
        ValueEnforcer.notNull((Object)ebi43InvoiceType, (String)"ebInterfaceDocument");
        String string = ebi43InvoiceType.getInvoiceCurrency();
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setUBLVersionID("2.1");
        invoiceType.setInvoiceTypeCode(EbInterface43ToInvoiceConverter.getTypeCode(ebi43InvoiceType.getDocumentType(), InvoiceTypeCodeType::new));
        DocumentCurrencyCodeType documentCurrencyCodeType = invoiceType.setDocumentCurrencyCode(string);
        documentCurrencyCodeType.setListAgencyID("6");
        documentCurrencyCodeType.setListID("ISO 4217 Alpha");
        if (ebi43InvoiceType.isIsDuplicate() != null) {
            invoiceType.setCopyIndicator(ebi43InvoiceType.isIsDuplicate().booleanValue());
        }
        invoiceType.setID(ebi43InvoiceType.getInvoiceNumber());
        invoiceType.setIssueDate(ebi43InvoiceType.getInvoiceDate());
        Object object8 = ebi43InvoiceType.getCancelledOriginalDocument();
        if (object8 != null) {
            documentReferenceType22 = new DocumentReferenceType();
            documentReferenceType22.setID(object8.getInvoiceNumber());
            documentReferenceType22.setIssueDate(object8.getInvoiceDate());
            documentReferenceType22.setDocumentType("CancelledOriginalDocument");
            documentReferenceType22.setDocumentTypeCode(EbInterface43ToInvoiceConverter.getTypeCode(object8.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)object8.getComment())) {
                documentReferenceType22.addDocumentDescription(new DocumentDescriptionType(object8.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType22);
        }
        for (DocumentReferenceType documentReferenceType22 : ebi43InvoiceType.getRelatedDocument()) {
            documentReferenceType = new DocumentReferenceType();
            documentReferenceType.setID(documentReferenceType22.getInvoiceNumber());
            documentReferenceType.setIssueDate(documentReferenceType22.getInvoiceDate());
            documentReferenceType.setDocumentType("RelatedDocument");
            documentReferenceType.setDocumentTypeCode(EbInterface43ToInvoiceConverter.getTypeCode(documentReferenceType22.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)documentReferenceType22.getComment())) {
                documentReferenceType.addDocumentDescription(new DocumentDescriptionType(documentReferenceType22.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType);
        }
        object8 = EbInterface43ToInvoiceConverter.convertDelivery(ebi43InvoiceType.getDelivery(), this.m_aContentLocale);
        if (object8 != null) {
            if (invoiceType.getInvoicePeriodCount() == 0 && object8.getRequestedDeliveryPeriod() != null) {
                invoiceType.addInvoicePeriod(object8.getRequestedDeliveryPeriod());
            }
            invoiceType.addDelivery((DeliveryType)object8);
        }
        if ((object8 = ebi43InvoiceType.getBiller()) != null) {
            documentReferenceType22 = new SupplierPartyType();
            documentReferenceType = EbInterface43ToInvoiceConverter.convertParty(object8.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface43ToInvoiceConverter.createTaxSchemeVAT());
                companyIDType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                companyIDType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getInvoiceRecipientsBillerID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setCustomerAssignedAccountID(object8.getInvoiceRecipientsBillerID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getInvoiceRecipientsBillerID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (CompanyIDType companyIDType2 : object8.getFurtherIdentification()) {
                object6 = new DocumentReferenceType();
                object52 = new IDType();
                object52.setValue(companyIDType2.getValue());
                object52.setSchemeID(companyIDType2.getIdentificationType());
                object6.setID((IDType)object52);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object6);
            }
            invoiceType.setAccountingSupplierParty((SupplierPartyType)documentReferenceType22);
        }
        if ((object8 = ebi43InvoiceType.getInvoiceRecipient()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface43ToInvoiceConverter.convertParty(object8.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface43ToInvoiceConverter.createTaxSchemeVAT());
                companyIDType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                companyIDType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getBillersInvoiceRecipientID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object8.getBillersInvoiceRecipientID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getBillersInvoiceRecipientID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (CompanyIDType companyIDType2 : object8.getFurtherIdentification()) {
                object6 = new AdditionalAccountIDType();
                object6.setValue(companyIDType2.getValue());
                object6.setSchemeID(companyIDType2.getIdentificationType());
                documentReferenceType22.addAdditionalAccountID((AdditionalAccountIDType)object6);
            }
            object7 = object8.getOrderReference();
            if (object7 != null) {
                companyIDType2 = new OrderReferenceType();
                companyIDType2.setID(object7.getOrderID());
                if (object7.getReferenceDate() != null) {
                    companyIDType2.setIssueDate(object7.getReferenceDate());
                }
                invoiceType.setOrderReference((OrderReferenceType)companyIDType2);
            }
            invoiceType.setAccountingCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        if ((object8 = ebi43InvoiceType.getOrderingParty()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface43ToInvoiceConverter.convertParty(object8.getAddress(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface43ToInvoiceConverter.createTaxSchemeVAT());
                companyIDType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                companyIDType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getBillersOrderingPartyID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object8.getBillersOrderingPartyID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getBillersOrderingPartyID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (CompanyIDType companyIDType2 : object8.getFurtherIdentification()) {
                object6 = new DocumentReferenceType();
                object52 = new IDType();
                object52.setValue(companyIDType2.getValue());
                object52.setSchemeID(companyIDType2.getIdentificationType());
                object6.setID((IDType)object52);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object6);
            }
            invoiceType.setBuyerCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        object8 = BigDecimal.ZERO;
        documentReferenceType22 = ebi43InvoiceType.getDetails();
        int n = 1;
        for (CompanyIDType companyIDType2 : documentReferenceType22.getItemList()) {
            for (Object object52 : companyIDType2.getListLineItem()) {
                Ebi43OtherVATableTaxBaseType ebi43OtherVATableTaxBaseType;
                AllowanceChargeType allowanceChargeType2;
                object42 = new InvoiceLineType();
                object42.setID(object52.getPositionNumber() != null ? object52.getPositionNumber().toString() : Integer.toString(n));
                priceType2 = StringHelper.trim((String)object52.getQuantity().getUnit());
                if (priceType2 == null) {
                    priceType2 = "C62";
                }
                object42.setInvoicedQuantity(object52.getQuantity().getValue()).setUnitCode((String)priceType2);
                object42.setLineExtensionAmount(object52.getLineItemAmount()).setCurrencyID(string);
                allowanceChargeType3 = new PriceType();
                allowanceChargeType3.setPriceAmount(object52.getUnitPrice().getValue()).setCurrencyID(string);
                if (object52.getUnitPrice().getBaseQuantity() != null) {
                    allowanceChargeType3.setBaseQuantity(object52.getUnitPrice().getBaseQuantity());
                }
                object42.setPrice((PriceType)allowanceChargeType3);
                if (object52.getDelivery() != null) {
                    object42.addDelivery(EbInterface43ToInvoiceConverter.convertDelivery(object52.getDelivery(), this.m_aContentLocale));
                }
                object3 = new ItemType();
                for (Iterator iterator : object52.getDescription()) {
                    object3.addDescription(new DescriptionType((String)((Object)iterator)));
                }
                object3.setPackSizeNumeric(BigDecimal.ONE);
                if (object52.getTaxExemption() != null) {
                    object2 = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("E");
                    object2.setPercent(BigDecimal.ZERO);
                    if (StringHelper.hasText((String)object52.getTaxExemption().getValue())) {
                        object2.addTaxExemptionReason(new TaxExemptionReasonType(object52.getTaxExemption().getValue()));
                    }
                } else {
                    object2 = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("S");
                    object2.setPercent(object52.getVATRate().getValue());
                    if (StringHelper.hasText((String)object52.getVATRate().getTaxCode())) {
                        object2.setName(object52.getVATRate().getTaxCode());
                    }
                }
                object3.addClassifiedTaxCategory((TaxCategoryType)object2);
                if (object52.getReductionAndSurchargeListLineItemDetails() != null) {
                    for (Iterator iterator : object52.getReductionAndSurchargeListLineItemDetails().getReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem()) {
                        object9 = iterator.getValue();
                        allowanceChargeType2 = new AllowanceChargeType();
                        if (object9 instanceof Ebi43OtherVATableTaxBaseType) {
                            ebi43OtherVATableTaxBaseType = (Ebi43OtherVATableTaxBaseType)object9;
                            allowanceChargeType2.setChargeIndicator(true);
                            allowanceChargeType2.setBaseAmount(ebi43OtherVATableTaxBaseType.getBaseAmount()).setCurrencyID(string);
                            if (ebi43OtherVATableTaxBaseType.getPercentage() != null) {
                                allowanceChargeType2.setMultiplierFactorNumeric(ebi43OtherVATableTaxBaseType.getPercentage().divide(CGlobal.BIGDEC_100));
                            }
                            if (ebi43OtherVATableTaxBaseType.getAmount() != null) {
                                allowanceChargeType2.setAmount(ebi43OtherVATableTaxBaseType.getAmount()).setCurrencyID(string);
                            } else if (ebi43OtherVATableTaxBaseType.getPercentage() != null) {
                                allowanceChargeType2.setAmount(MathHelper.getPercentValue((BigDecimal)ebi43OtherVATableTaxBaseType.getBaseAmount(), (BigDecimal)ebi43OtherVATableTaxBaseType.getPercentage())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi43OtherVATableTaxBaseType.getTaxID())) {
                                allowanceChargeType2.setAllowanceChargeReasonCode(ebi43OtherVATableTaxBaseType.getTaxID());
                            }
                            if (StringHelper.hasText((String)ebi43OtherVATableTaxBaseType.getComment())) {
                                allowanceChargeType2.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi43OtherVATableTaxBaseType.getComment()));
                            }
                        } else {
                            ebi43OtherVATableTaxBaseType = (Ebi43ReductionAndSurchargeBaseType)object9;
                            boolean bl = iterator.getName().getLocalPart().equals("ReductionListLineItem");
                            allowanceChargeType2.setChargeIndicator(!bl);
                            allowanceChargeType2.setBaseAmount(ebi43OtherVATableTaxBaseType.getBaseAmount()).setCurrencyID(string);
                            if (ebi43OtherVATableTaxBaseType.getPercentage() != null) {
                                allowanceChargeType2.setMultiplierFactorNumeric(ebi43OtherVATableTaxBaseType.getPercentage().divide(CGlobal.BIGDEC_100));
                            }
                            if (ebi43OtherVATableTaxBaseType.getAmount() != null) {
                                allowanceChargeType2.setAmount(ebi43OtherVATableTaxBaseType.getAmount()).setCurrencyID(string);
                            } else if (ebi43OtherVATableTaxBaseType.getPercentage() != null) {
                                allowanceChargeType2.setAmount(MathHelper.getPercentValue((BigDecimal)ebi43OtherVATableTaxBaseType.getBaseAmount(), (BigDecimal)ebi43OtherVATableTaxBaseType.getPercentage())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi43OtherVATableTaxBaseType.getComment())) {
                                allowanceChargeType2.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi43OtherVATableTaxBaseType.getComment()));
                            }
                        }
                        if (allowanceChargeType2.getAmount() == null) continue;
                        object42.addAllowanceCharge(allowanceChargeType2);
                    }
                }
                for (Iterator iterator : object52.getArticleNumber()) {
                    object9 = new ItemIdentificationType();
                    object9.setID(iterator.getValue());
                    if (iterator.getArticleNumberType() != null) {
                        allowanceChargeType2 = new PartyType();
                        ebi43OtherVATableTaxBaseType = new PartyIdentificationType();
                        ebi43OtherVATableTaxBaseType.setID(iterator.getArticleNumberType().value());
                        allowanceChargeType2.addPartyIdentification((PartyIdentificationType)ebi43OtherVATableTaxBaseType);
                        object9.setIssuerParty((PartyType)allowanceChargeType2);
                    }
                    object3.addManufacturersItemIdentification((ItemIdentificationType)object9);
                }
                object2 = object52.getAdditionalInformation();
                if (object2 != null) {
                    Iterator iterator;
                    for (Object object9 : object2.getSerialNumber()) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("SerialNumber", (String)object9));
                    }
                    for (Object object9 : object2.getSerialNumber()) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("ChargeNumber", (String)object9));
                    }
                    iterator = object2.getClassification().iterator();
                    while (iterator.hasNext()) {
                        object9 = (Ebi43ClassificationType)iterator.next();
                        allowanceChargeType2 = new CommodityClassificationType();
                        ebi43OtherVATableTaxBaseType = new ItemClassificationCodeType();
                        ebi43OtherVATableTaxBaseType.setValue(object9.getValue());
                        ebi43OtherVATableTaxBaseType.setName(object9.getClassificationSchema());
                        allowanceChargeType2.setItemClassificationCode((ItemClassificationCodeType)ebi43OtherVATableTaxBaseType);
                        object3.addCommodityClassification((CommodityClassificationType)allowanceChargeType2);
                    }
                    if (object2.getAlternativeQuantity() != null) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("AlternativeQuantity", object2.getAlternativeQuantity().getValue().toString()));
                    }
                    if (object2.getSize() != null) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("Size", object2.getSize()));
                    }
                    if (object2.getWeight() != null) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("Weight", object2.getWeight().getValue().toString()));
                    }
                    if (object2.getBoxes() != null) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("Boxes", object2.getBoxes().toString()));
                    }
                    if (object2.getColor() != null) {
                        object3.addAdditionalItemProperty(EbInterface43ToInvoiceConverter.createItemProperty("Color", object2.getColor()));
                    }
                }
                object42.setItem((ItemType)object3);
                object3 = object52.getInvoiceRecipientsOrderReference();
                if (object3 != null) {
                    object2 = new OrderLineReferenceType();
                    boolean bl = false;
                    object9 = new OrderReferenceType();
                    boolean bl2 = false;
                    if (object3.getOrderID() != null) {
                        object9.setID(object3.getOrderID());
                        bl2 = true;
                    }
                    if (object3.getReferenceDate() != null) {
                        object9.setIssueDate(object3.getReferenceDate());
                        bl2 = true;
                    }
                    if (bl2) {
                        object2.setOrderReference((OrderReferenceType)object9);
                        bl = true;
                    }
                    if (object3.getOrderPositionNumber() != null) {
                        object2.setLineID(object3.getOrderPositionNumber());
                        bl = true;
                    }
                    if (bl) {
                        object42.addOrderLineReference((OrderLineReferenceType)object2);
                    }
                }
                invoiceType.addInvoiceLine((InvoiceLineType)object42);
                object8 = ((BigDecimal)object8).add(object52.getLineItemAmount());
                ++n;
            }
        }
        object7 = BigDecimal.ZERO;
        int n2 = 1;
        for (Object object52 : documentReferenceType22.getBelowTheLineItem()) {
            object42 = new InvoiceLineType();
            object42.setID("BTL" + n2);
            object42.addNote(new NoteType("BelowTheLineItem"));
            object42.setInvoicedQuantity(BigDecimal.ONE).setUnitCode("C62");
            object42.setLineExtensionAmount(object52.getLineItemAmount()).setCurrencyID(string);
            priceType2 = new PriceType();
            priceType2.setPriceAmount(object52.getLineItemAmount()).setCurrencyID(string);
            priceType2.setBaseQuantity(BigDecimal.ONE);
            object42.setPrice(priceType2);
            allowanceChargeType3 = new ItemType();
            if (StringHelper.hasText((String)object52.getDescription())) {
                allowanceChargeType3.addDescription(new DescriptionType(object52.getDescription()));
            }
            allowanceChargeType3.setPackSizeNumeric(BigDecimal.ONE);
            object3 = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("E");
            object3.setPercent(BigDecimal.ZERO);
            object3.addTaxExemptionReason(new TaxExemptionReasonType("BelowTheLine - tax already handled"));
            allowanceChargeType3.addClassifiedTaxCategory((TaxCategoryType)object3);
            object42.setItem((ItemType)allowanceChargeType3);
            invoiceType.addInvoiceLine((InvoiceLineType)object42);
            object8 = ((BigDecimal)object8).add(object52.getLineItemAmount());
            object7 = ((BigDecimal)object7).add(object52.getLineItemAmount());
            ++n2;
        }
        EbInterface43ToInvoiceConverter._convertPayment(ebi43InvoiceType, invoiceType);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        object6 = BigDecimal.ZERO;
        if (ebi43InvoiceType.getReductionAndSurchargeDetails() != null) {
            for (Object object42 : ebi43InvoiceType.getReductionAndSurchargeDetails().getReductionOrSurchargeOrOtherVATableTax()) {
                priceType2 = object42.getValue();
                allowanceChargeType3 = new AllowanceChargeType();
                object3 = null;
                if (priceType2 instanceof Ebi43OtherVATableTaxType) {
                    object2 = (Ebi43OtherVATableTaxType)priceType2;
                    allowanceChargeType3.setChargeIndicator(true);
                    allowanceChargeType3.setBaseAmount(object2.getBaseAmount()).setCurrencyID(string);
                    if (object2.getPercentage() != null) {
                        allowanceChargeType3.setMultiplierFactorNumeric(object2.getPercentage().divide(CGlobal.BIGDEC_100));
                    }
                    if (object2.getAmount() != null) {
                        object3 = object2.getAmount();
                    } else if (object2.getPercentage() != null) {
                        object3 = MathHelper.getPercentValue((BigDecimal)object2.getBaseAmount(), (BigDecimal)object2.getPercentage());
                    }
                    if (StringHelper.hasText((String)object2.getTaxID())) {
                        allowanceChargeType3.setAllowanceChargeReasonCode(object2.getTaxID());
                    }
                    if (StringHelper.hasText((String)object2.getComment())) {
                        allowanceChargeType3.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    TaxCategoryType taxCategoryType = EbInterface43ToInvoiceConverter.createTaxCategoryOther();
                    taxCategoryType.setPercent(object2.getPercentage());
                    allowanceChargeType3.addTaxCategory(taxCategoryType);
                } else {
                    object2 = (Ebi43ReductionAndSurchargeType)priceType2;
                    boolean bl = object42.getName().getLocalPart().equals("Reduction");
                    allowanceChargeType3.setChargeIndicator(!bl);
                    allowanceChargeType3.setBaseAmount(object2.getBaseAmount()).setCurrencyID(string);
                    if (object2.getPercentage() != null) {
                        allowanceChargeType3.setMultiplierFactorNumeric(object2.getPercentage().divide(CGlobal.BIGDEC_100));
                    }
                    if (object2.getAmount() != null) {
                        object3 = object2.getAmount();
                    } else if (object2.getPercentage() != null) {
                        object3 = MathHelper.getPercentValue((BigDecimal)object2.getBaseAmount(), (BigDecimal)object2.getPercentage());
                    }
                    if (StringHelper.hasText((String)object2.getComment())) {
                        allowanceChargeType3.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    object9 = object2.getVATRate();
                    TaxCategoryType taxCategoryType = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("S");
                    taxCategoryType.setPercent(object9.getValue());
                    allowanceChargeType3.addTaxCategory(taxCategoryType);
                }
                if (object3 != null) {
                    allowanceChargeType3.setAmount((BigDecimal)object3).setCurrencyID(string);
                    if (allowanceChargeType3.isChargeIndicatorValue(false)) {
                        bigDecimal = bigDecimal.add((BigDecimal)object3);
                    } else {
                        object6 = ((BigDecimal)object6).add((BigDecimal)object3);
                    }
                }
                invoiceType.addAllowanceCharge(allowanceChargeType3);
            }
        }
        object52 = new TaxTotalType();
        object42 = BigDecimal.ZERO;
        for (AllowanceChargeType allowanceChargeType3 : ebi43InvoiceType.getTax().getVAT().getVATItem()) {
            object3 = new TaxSubtotalType();
            object3.setTaxableAmount(allowanceChargeType3.getTaxedAmount()).setCurrencyID(string);
            object3.setTaxAmount(allowanceChargeType3.getAmount()).setCurrencyID(string);
            if (allowanceChargeType3.getTaxExemption() != null) {
                object2 = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("E");
                object2.setPercent(BigDecimal.ZERO);
                if (StringHelper.hasText((String)allowanceChargeType3.getTaxExemption().getValue())) {
                    object2.addTaxExemptionReason(new TaxExemptionReasonType(allowanceChargeType3.getTaxExemption().getValue()));
                }
            } else {
                object2 = EbInterface43ToInvoiceConverter.createTaxCategoryVAT("S");
                object2.setPercent(allowanceChargeType3.getVATRate().getValue());
                if (StringHelper.hasText((String)allowanceChargeType3.getVATRate().getTaxCode())) {
                    object2.setName(allowanceChargeType3.getVATRate().getTaxCode());
                }
            }
            object3.setTaxCategory((TaxCategoryType)object2);
            object52.addTaxSubtotal(object3);
            object42 = ((BigDecimal)object42).add(allowanceChargeType3.getAmount());
        }
        for (AllowanceChargeType allowanceChargeType3 : ebi43InvoiceType.getTax().getOtherTax()) {
            object3 = new TaxSubtotalType();
            object3.setTaxAmount(allowanceChargeType3.getAmount()).setCurrencyID(string);
            object2 = EbInterface43ToInvoiceConverter.createTaxCategoryOther();
            if (StringHelper.hasText((String)allowanceChargeType3.getComment())) {
                object2.getTaxScheme().setName(allowanceChargeType3.getComment());
            }
            object3.setTaxCategory((TaxCategoryType)object2);
            object52.addTaxSubtotal(object3);
            object42 = ((BigDecimal)object42).add(allowanceChargeType3.getAmount());
        }
        object52.setTaxAmount((BigDecimal)object42).setCurrencyID(string);
        invoiceType.addTaxTotal((TaxTotalType)object52);
        object52 = BigDecimal.ZERO;
        for (PriceType priceType2 : invoiceType.getInvoiceLine()) {
            object52 = ((BigDecimal)object52).add(priceType2.getLineExtensionAmountValue());
        }
        object42 = new MonetaryTotalType();
        object42.setLineExtensionAmount((BigDecimal)object52).setCurrencyID(string);
        object42.setAllowanceTotalAmount((BigDecimal)object6).setCurrencyID(string);
        object42.setChargeTotalAmount(bigDecimal).setCurrencyID(string);
        object42.setTaxExclusiveAmount((BigDecimal)object8).setCurrencyID(string);
        object42.setTaxInclusiveAmount(ebi43InvoiceType.getTotalGrossAmount()).setCurrencyID(string);
        object42.setPayableAmount(ebi43InvoiceType.getPayableAmount()).setCurrencyID(string);
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object42);
        if (StringHelper.hasText((String)ebi43InvoiceType.getComment())) {
            invoiceType.addNote(new NoteType(ebi43InvoiceType.getComment()));
        }
        return invoiceType;
    }
}

