/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterface60ToUBLConverter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v60.Ebi60AccountType;
import com.helger.ebinterface.v60.Ebi60ArticleNumberType;
import com.helger.ebinterface.v60.Ebi60InvoiceType;
import com.helger.ebinterface.v60.Ebi60OtherVATableTaxType;
import com.helger.ebinterface.v60.Ebi60PaymentConditionsType;
import com.helger.ebinterface.v60.Ebi60PaymentMethodType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v60.Ebi60ReductionAndSurchargeType;
import com.helger.ebinterface.v60.Ebi60SEPADirectDebitType;
import com.helger.ebinterface.v60.Ebi60TaxItemType;
import com.helger.ebinterface.v60.Ebi60UniversalBankTransactionType;
import java.math.BigDecimal;
import java.util.Locale;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialInstitutionType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AdditionalAccountIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

public class EbInterface60ToInvoiceConverter
extends AbstractEbInterface60ToUBLConverter {
    public EbInterface60ToInvoiceConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    private static void _convertPayment(@Nonnull Ebi60InvoiceType ebi60InvoiceType, @Nonnull InvoiceType invoiceType) {
        Ebi60UniversalBankTransactionType ebi60UniversalBankTransactionType;
        Ebi60SEPADirectDebitType ebi60SEPADirectDebitType;
        Object object3;
        Object object2;
        Ebi60PaymentMethodType ebi60PaymentMethodType = ebi60InvoiceType.getPaymentMethod();
        Ebi60PaymentConditionsType ebi60PaymentConditionsType = ebi60InvoiceType.getPaymentConditions();
        if (ebi60PaymentMethodType != null && (object2 = ebi60PaymentMethodType.getNoPayment()) == null && (object3 = ebi60PaymentMethodType.getOtherPayment()) == null) {
            ebi60SEPADirectDebitType = ebi60PaymentMethodType.getSEPADirectDebit();
            if (ebi60SEPADirectDebitType != null) {
                ebi60UniversalBankTransactionType = new PaymentMeansType();
                ebi60UniversalBankTransactionType.setPaymentMeansCode("59");
                if (ebi60PaymentConditionsType != null) {
                    ebi60UniversalBankTransactionType.setPaymentDueDate(ebi60PaymentConditionsType.getDueDate());
                }
                if (StringHelper.hasText((String)ebi60PaymentMethodType.getComment())) {
                    ebi60UniversalBankTransactionType.addInstructionNote(new InstructionNoteType(ebi60PaymentMethodType.getComment()));
                }
                invoiceType.addPaymentMeans((PaymentMeansType)ebi60UniversalBankTransactionType);
            } else {
                ebi60UniversalBankTransactionType = ebi60PaymentMethodType.getUniversalBankTransaction();
                if (ebi60UniversalBankTransactionType != null) {
                    PaymentMeansType paymentMeansType = new PaymentMeansType();
                    paymentMeansType.setPaymentMeansCode("30");
                    paymentMeansType.setPaymentChannelCode("IBAN");
                    if (ebi60UniversalBankTransactionType.hasBeneficiaryAccountEntries()) {
                        Ebi60AccountType ebi60AccountType = ebi60UniversalBankTransactionType.getBeneficiaryAccountAtIndex(0);
                        FinancialAccountType financialAccountType = new FinancialAccountType();
                        BranchType branchType = new BranchType();
                        FinancialInstitutionType financialInstitutionType = new FinancialInstitutionType();
                        IDType iDType = new IDType();
                        if (StringHelper.hasText((String)ebi60AccountType.getBIC())) {
                            iDType.setValue(ebi60AccountType.getBIC());
                            iDType.setSchemeID("BIC");
                        } else if (ebi60AccountType.getBankCode() != null) {
                            iDType.setValue(ebi60AccountType.getBankCode().getValue().toString());
                            iDType.setSchemeID(ebi60AccountType.getBankCode().getBankCodeType());
                        } else if (StringHelper.hasText((String)ebi60AccountType.getBankName())) {
                            iDType.setValue(ebi60AccountType.getBankName());
                            iDType.setSchemeID("name");
                        }
                        if (StringHelper.hasText((String)iDType.getValue())) {
                            financialInstitutionType.setID(iDType);
                        }
                        if (financialInstitutionType.getID() != null) {
                            branchType.setFinancialInstitution(financialInstitutionType);
                        }
                        iDType = new IDType();
                        if (StringHelper.hasText((String)ebi60AccountType.getIBAN())) {
                            iDType.setValue(ebi60AccountType.getIBAN());
                            iDType.setSchemeID("IBAN");
                        } else if (StringHelper.hasText((String)ebi60AccountType.getBankAccountNr())) {
                            iDType.setValue(ebi60AccountType.getBankAccountNr());
                            iDType.setSchemeID("local");
                        }
                        if (StringHelper.hasText((String)iDType.getValue())) {
                            financialAccountType.setID(iDType);
                        }
                        financialAccountType.setName(ebi60AccountType.getBankAccountOwner());
                        if (branchType.getFinancialInstitution() != null) {
                            financialAccountType.setFinancialInstitutionBranch(branchType);
                        }
                        paymentMeansType.setPayeeFinancialAccount(financialAccountType);
                    }
                    if (ebi60UniversalBankTransactionType.getPaymentReference() != null) {
                        paymentMeansType.setInstructionID(new InstructionIDType(ebi60UniversalBankTransactionType.getPaymentReference().getValue()));
                    }
                    if (ebi60PaymentConditionsType != null) {
                        paymentMeansType.setPaymentDueDate(ebi60PaymentConditionsType.getDueDate());
                    }
                    if (StringHelper.hasText((String)ebi60PaymentMethodType.getComment())) {
                        paymentMeansType.addInstructionNote(new InstructionNoteType(ebi60PaymentMethodType.getComment()));
                    }
                    invoiceType.addPaymentMeans(paymentMeansType);
                } else {
                    throw new IllegalStateException("Unsupported payment method present!");
                }
            }
        }
        if (ebi60PaymentConditionsType != null) {
            object2 = new PaymentTermsType();
            object2.setPaymentDueDate(ebi60PaymentConditionsType.getDueDate());
            if (ebi60PaymentConditionsType.getMinimumPayment() != null) {
                object3 = MathHelper.isEQ0((BigDecimal)ebi60InvoiceType.getPayableAmount()) ? BigDecimal.ZERO : ebi60PaymentConditionsType.getMinimumPayment().divide(ebi60InvoiceType.getPayableAmount(), 4, ROUNDING_MODE).multiply(CGlobal.BIGDEC_100);
                object2.setPaymentPercent((BigDecimal)object3);
            }
            if (StringHelper.hasText((String)ebi60PaymentConditionsType.getComment())) {
                object2.addNote(new NoteType(ebi60PaymentConditionsType.getComment()));
            }
            invoiceType.addPaymentTerms((PaymentTermsType)object2);
            for (Object object3 : ebi60PaymentConditionsType.getDiscount()) {
                ebi60SEPADirectDebitType = new PaymentTermsType();
                ebi60UniversalBankTransactionType = new PeriodType();
                ebi60UniversalBankTransactionType.setEndDate(object3.getPaymentDate());
                ebi60SEPADirectDebitType.setSettlementPeriod((PeriodType)ebi60UniversalBankTransactionType);
                if (object3.getBaseAmount() != null) {
                    ebi60SEPADirectDebitType.setAmount(object3.getBaseAmount()).setCurrencyID(ebi60InvoiceType.getInvoiceCurrency());
                }
                ebi60SEPADirectDebitType.setSettlementDiscountPercent(object3.getPercentage());
                if (object3.getAmount() != null) {
                    ebi60SEPADirectDebitType.setSettlementDiscountAmount(object3.getAmount()).setCurrencyID(ebi60InvoiceType.getInvoiceCurrency());
                }
                if (StringHelper.hasText((String)object3.getComment())) {
                    ebi60SEPADirectDebitType.addNote(new NoteType(object3.getComment()));
                }
                invoiceType.addPaymentTerms((PaymentTermsType)ebi60SEPADirectDebitType);
            }
        }
    }

    @Nonnull
    public InvoiceType convertInvoice(@Nonnull Ebi60InvoiceType ebi60InvoiceType) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object52;
        Object object62;
        Object object7;
        Object object82;
        Object object9;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType22;
        ValueEnforcer.notNull((Object)ebi60InvoiceType, (String)"ebInterfaceDocument");
        String string = ebi60InvoiceType.getInvoiceCurrency();
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setUBLVersionID("2.1");
        invoiceType.setInvoiceTypeCode(EbInterface60ToInvoiceConverter.getTypeCode(ebi60InvoiceType.getDocumentType(), InvoiceTypeCodeType::new));
        DocumentCurrencyCodeType documentCurrencyCodeType = invoiceType.setDocumentCurrencyCode(string);
        documentCurrencyCodeType.setListAgencyID("6");
        documentCurrencyCodeType.setListID("ISO 4217 Alpha");
        if (ebi60InvoiceType.isIsDuplicate() != null) {
            invoiceType.setCopyIndicator(ebi60InvoiceType.isIsDuplicate().booleanValue());
        }
        invoiceType.setID(ebi60InvoiceType.getInvoiceNumber());
        invoiceType.setIssueDate(ebi60InvoiceType.getInvoiceDate());
        Object object10 = ebi60InvoiceType.getCancelledOriginalDocument();
        if (object10 != null) {
            documentReferenceType22 = new DocumentReferenceType();
            documentReferenceType22.setID(object10.getInvoiceNumber());
            documentReferenceType22.setIssueDate(object10.getInvoiceDate());
            documentReferenceType22.setDocumentType("CancelledOriginalDocument");
            documentReferenceType22.setDocumentTypeCode(EbInterface60ToInvoiceConverter.getTypeCode(object10.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)object10.getComment())) {
                documentReferenceType22.addDocumentDescription(new DocumentDescriptionType(object10.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType22);
        }
        for (DocumentReferenceType documentReferenceType22 : ebi60InvoiceType.getRelatedDocument()) {
            documentReferenceType = new DocumentReferenceType();
            documentReferenceType.setID(documentReferenceType22.getInvoiceNumber());
            documentReferenceType.setIssueDate(documentReferenceType22.getInvoiceDate());
            documentReferenceType.setDocumentType("RelatedDocument");
            documentReferenceType.setDocumentTypeCode(EbInterface60ToInvoiceConverter.getTypeCode(documentReferenceType22.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)documentReferenceType22.getComment())) {
                documentReferenceType.addDocumentDescription(new DocumentDescriptionType(documentReferenceType22.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType);
        }
        object10 = EbInterface60ToInvoiceConverter.convertDelivery(ebi60InvoiceType.getDelivery(), this.m_aContentLocale);
        if (object10 != null) {
            if (invoiceType.getInvoicePeriodCount() == 0 && object10.getRequestedDeliveryPeriod() != null) {
                invoiceType.addInvoicePeriod(object10.getRequestedDeliveryPeriod());
            }
            invoiceType.addDelivery((DeliveryType)object10);
        }
        if ((object10 = ebi60InvoiceType.getBiller()) != null) {
            documentReferenceType22 = new SupplierPartyType();
            documentReferenceType = EbInterface60ToInvoiceConverter.convertParty(object10.getAddress(), object10.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object10.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object9 = new PartyTaxSchemeType();
                object9.setTaxScheme(EbInterface60ToInvoiceConverter.createTaxSchemeVAT());
                object82 = object9.setCompanyID(object10.getVATIdentificationNumber());
                object82.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object9);
            }
            if (StringHelper.hasText((String)object10.getInvoiceRecipientsBillerID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setCustomerAssignedAccountID(object10.getInvoiceRecipientsBillerID());
                object9 = new PartyIdentificationType();
                object9.setID(object10.getInvoiceRecipientsBillerID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object9);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Object object82 : object10.getFurtherIdentification()) {
                object7 = new DocumentReferenceType();
                object62 = new IDType();
                object62.setValue(object82.getValue());
                object62.setSchemeID(object82.getIdentificationType());
                object7.setID((IDType)object62);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object7);
            }
            invoiceType.setAccountingSupplierParty((SupplierPartyType)documentReferenceType22);
        }
        if ((object10 = ebi60InvoiceType.getInvoiceRecipient()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface60ToInvoiceConverter.convertParty(object10.getAddress(), object10.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object10.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object9 = new PartyTaxSchemeType();
                object9.setTaxScheme(EbInterface60ToInvoiceConverter.createTaxSchemeVAT());
                object82 = object9.setCompanyID(object10.getVATIdentificationNumber());
                object82.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object9);
            }
            if (StringHelper.hasText((String)object10.getBillersInvoiceRecipientID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object10.getBillersInvoiceRecipientID());
                object9 = new PartyIdentificationType();
                object9.setID(object10.getBillersInvoiceRecipientID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object9);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Object object82 : object10.getFurtherIdentification()) {
                object7 = new AdditionalAccountIDType();
                object7.setValue(object82.getValue());
                object7.setSchemeID(object82.getIdentificationType());
                documentReferenceType22.addAdditionalAccountID((AdditionalAccountIDType)object7);
            }
            object9 = object10.getOrderReference();
            if (object9 != null) {
                object82 = new OrderReferenceType();
                object82.setID(object9.getOrderID());
                if (object9.getReferenceDate() != null) {
                    object82.setIssueDate(object9.getReferenceDate());
                }
                invoiceType.setOrderReference((OrderReferenceType)object82);
            }
            invoiceType.setAccountingCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        if ((object10 = ebi60InvoiceType.getOrderingParty()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface60ToInvoiceConverter.convertParty(object10.getAddress(), object10.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object10.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object9 = new PartyTaxSchemeType();
                object9.setTaxScheme(EbInterface60ToInvoiceConverter.createTaxSchemeVAT());
                object82 = object9.setCompanyID(object10.getVATIdentificationNumber());
                object82.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object9);
            }
            if (StringHelper.hasText((String)object10.getBillersOrderingPartyID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object10.getBillersOrderingPartyID());
                object9 = new PartyIdentificationType();
                object9.setID(object10.getBillersOrderingPartyID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object9);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Object object82 : object10.getFurtherIdentification()) {
                object7 = new DocumentReferenceType();
                object62 = new IDType();
                object62.setValue(object82.getValue());
                object62.setSchemeID(object82.getIdentificationType());
                object7.setID((IDType)object62);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object7);
            }
            invoiceType.setBuyerCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        object10 = BigDecimal.ZERO;
        documentReferenceType22 = ebi60InvoiceType.getDetails();
        int n = 1;
        for (Object object82 : documentReferenceType22.getItemList()) {
            for (Object object62 : object82.getListLineItem()) {
                Ebi60OtherVATableTaxType ebi60OtherVATableTaxType;
                AllowanceChargeType allowanceChargeType;
                Object object11;
                String string22;
                object52 = new InvoiceLineType();
                object52.setID(object62.getPositionNumber() != null ? object62.getPositionNumber().toString() : Integer.toString(n));
                object42 = StringHelper.trim((String)object62.getQuantity().getUnit());
                if (object42 == null) {
                    object42 = "C62";
                }
                object52.setInvoicedQuantity(object62.getQuantity().getValue()).setUnitCode((String)object42);
                object52.setLineExtensionAmount(object62.getLineItemAmount()).setCurrencyID(string);
                object3 = new PriceType();
                object3.setPriceAmount(object62.getUnitPrice().getValue()).setCurrencyID(string);
                if (object62.getUnitPrice().getBaseQuantity() != null) {
                    object3.setBaseQuantity(object62.getUnitPrice().getBaseQuantity());
                }
                object52.setPrice((PriceType)object3);
                if (object62.getDelivery() != null) {
                    object52.addDelivery(EbInterface60ToInvoiceConverter.convertDelivery(object62.getDelivery(), this.m_aContentLocale));
                }
                object2 = new ItemType();
                for (String string22 : object62.getDescription()) {
                    object2.addDescription(new DescriptionType(string22));
                }
                object2.setPackSizeNumeric(BigDecimal.ONE);
                Ebi60TaxItemType ebi60TaxItemType = object62.getTaxItem();
                string22 = EbInterface60ToInvoiceConverter.createTaxCategoryVAT(ebi60TaxItemType.getTaxPercent().getTaxCategoryCode());
                string22.setPercent(ebi60TaxItemType.getTaxPercentValue());
                object2.addClassifiedTaxCategory((TaxCategoryType)string22);
                if (object62.getReductionAndSurchargeListLineItemDetails() != null) {
                    for (Ebi60ArticleNumberType ebi60ArticleNumberType : object62.getReductionAndSurchargeListLineItemDetails().getReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem()) {
                        object11 = ebi60ArticleNumberType.getValue();
                        allowanceChargeType = new AllowanceChargeType();
                        if (object11 instanceof Ebi60OtherVATableTaxType) {
                            ebi60OtherVATableTaxType = (Ebi60OtherVATableTaxType)object11;
                            allowanceChargeType.setChargeIndicator(true);
                            allowanceChargeType.setBaseAmount(ebi60OtherVATableTaxType.getTaxableAmount()).setCurrencyID(string);
                            allowanceChargeType.setMultiplierFactorNumeric(ebi60OtherVATableTaxType.getTaxPercentValue().divide(CGlobal.BIGDEC_100));
                            if (ebi60OtherVATableTaxType.getTaxAmount() != null) {
                                allowanceChargeType.setAmount(ebi60OtherVATableTaxType.getTaxAmount()).setCurrencyID(string);
                            } else {
                                allowanceChargeType.setAmount(MathHelper.getPercentValue((BigDecimal)ebi60OtherVATableTaxType.getTaxableAmount(), (BigDecimal)ebi60OtherVATableTaxType.getTaxPercentValue())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi60OtherVATableTaxType.getTaxID())) {
                                allowanceChargeType.setAllowanceChargeReasonCode(ebi60OtherVATableTaxType.getTaxID());
                            }
                            if (StringHelper.hasText((String)ebi60OtherVATableTaxType.getComment())) {
                                allowanceChargeType.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi60OtherVATableTaxType.getComment()));
                            }
                        } else {
                            ebi60OtherVATableTaxType = (Ebi60ReductionAndSurchargeBaseType)object11;
                            boolean bl = ebi60ArticleNumberType.getName().getLocalPart().equals("ReductionListLineItem");
                            allowanceChargeType.setChargeIndicator(!bl);
                            allowanceChargeType.setBaseAmount(ebi60OtherVATableTaxType.getBaseAmount()).setCurrencyID(string);
                            if (ebi60OtherVATableTaxType.getPercentage() != null) {
                                allowanceChargeType.setMultiplierFactorNumeric(ebi60OtherVATableTaxType.getPercentage().divide(CGlobal.BIGDEC_100));
                            }
                            if (ebi60OtherVATableTaxType.getAmount() != null) {
                                allowanceChargeType.setAmount(ebi60OtherVATableTaxType.getAmount()).setCurrencyID(string);
                            } else if (ebi60OtherVATableTaxType.getPercentage() != null) {
                                allowanceChargeType.setAmount(MathHelper.getPercentValue((BigDecimal)ebi60OtherVATableTaxType.getBaseAmount(), (BigDecimal)ebi60OtherVATableTaxType.getPercentage())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi60OtherVATableTaxType.getComment())) {
                                allowanceChargeType.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi60OtherVATableTaxType.getComment()));
                            }
                        }
                        if (allowanceChargeType.getAmount() == null) continue;
                        object52.addAllowanceCharge(allowanceChargeType);
                    }
                }
                for (Ebi60ArticleNumberType ebi60ArticleNumberType : object62.getArticleNumber()) {
                    object11 = new ItemIdentificationType();
                    object11.setID(ebi60ArticleNumberType.getValue());
                    if (ebi60ArticleNumberType.getArticleNumberType() != null) {
                        allowanceChargeType = new PartyType();
                        ebi60OtherVATableTaxType = new PartyIdentificationType();
                        ebi60OtherVATableTaxType.setID(ebi60ArticleNumberType.getArticleNumberType().value());
                        allowanceChargeType.addPartyIdentification((PartyIdentificationType)ebi60OtherVATableTaxType);
                        object11.setIssuerParty((PartyType)allowanceChargeType);
                    }
                    object2.addManufacturersItemIdentification((ItemIdentificationType)object11);
                }
                for (Ebi60ArticleNumberType ebi60ArticleNumberType : object62.getAdditionalInformation()) {
                    object2.addAdditionalItemProperty(EbInterface60ToInvoiceConverter.createItemProperty(ebi60ArticleNumberType.getKey(), ebi60ArticleNumberType.getValue()));
                }
                object52.setItem((ItemType)object2);
                object2 = object62.getInvoiceRecipientsOrderReference();
                if (object2 != null) {
                    ebi60TaxItemType = new OrderLineReferenceType();
                    boolean bl = false;
                    object = new OrderReferenceType();
                    boolean bl2 = false;
                    if (object2.getOrderID() != null) {
                        object.setID(object2.getOrderID());
                        bl2 = true;
                    }
                    if (object2.getReferenceDate() != null) {
                        object.setIssueDate(object2.getReferenceDate());
                        bl2 = true;
                    }
                    if (bl2) {
                        ebi60TaxItemType.setOrderReference((OrderReferenceType)object);
                        bl = true;
                    }
                    if (object2.getOrderPositionNumber() != null) {
                        ebi60TaxItemType.setLineID(object2.getOrderPositionNumber());
                        bl = true;
                    }
                    if (bl) {
                        object52.addOrderLineReference((OrderLineReferenceType)ebi60TaxItemType);
                    }
                }
                invoiceType.addInvoiceLine((InvoiceLineType)object52);
                object10 = ((BigDecimal)object10).add(object62.getLineItemAmount());
                ++n;
            }
        }
        EbInterface60ToInvoiceConverter._convertPayment(ebi60InvoiceType, invoiceType);
        object9 = BigDecimal.ZERO;
        object82 = BigDecimal.ZERO;
        if (ebi60InvoiceType.getReductionAndSurchargeDetails() != null) {
            for (Object object62 : ebi60InvoiceType.getReductionAndSurchargeDetails().getReductionOrSurchargeOrOtherVATableTax()) {
                object52 = object62.getValue();
                object42 = new AllowanceChargeType();
                if (object52 instanceof Ebi60OtherVATableTaxType) {
                    object2 = (Ebi60OtherVATableTaxType)object52;
                    object42.setChargeIndicator(true);
                    object42.setBaseAmount(object2.getTaxableAmount()).setCurrencyID(string);
                    object42.setMultiplierFactorNumeric(object2.getTaxPercentValue().divide(CGlobal.BIGDEC_100));
                    object3 = object2.getTaxAmount() != null ? object2.getTaxAmount() : MathHelper.getPercentValue((BigDecimal)object2.getTaxableAmount(), (BigDecimal)object2.getTaxPercentValue());
                    if (StringHelper.hasText((String)object2.getTaxID())) {
                        object42.setAllowanceChargeReasonCode(object2.getTaxID());
                    }
                    if (StringHelper.hasText((String)object2.getComment())) {
                        object42.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    TaxCategoryType taxCategoryType = EbInterface60ToInvoiceConverter.createTaxCategoryOther();
                    taxCategoryType.setPercent(object2.getTaxPercentValue());
                    object42.addTaxCategory(taxCategoryType);
                } else {
                    object2 = (Ebi60ReductionAndSurchargeType)object52;
                    boolean bl = object62.getName().getLocalPart().equals("Reduction");
                    object42.setChargeIndicator(!bl);
                    object42.setBaseAmount(object2.getBaseAmount()).setCurrencyID(string);
                    if (object2.getPercentage() != null) {
                        object42.setMultiplierFactorNumeric(object2.getPercentage().divide(CGlobal.BIGDEC_100));
                    }
                    object3 = object2.getAmount() != null ? object2.getAmount() : MathHelper.getPercentValue((BigDecimal)object2.getBaseAmount(), (BigDecimal)object2.getPercentage());
                    if (StringHelper.hasText((String)object2.getComment())) {
                        object42.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    Ebi60TaxItemType ebi60TaxItemType = object2.getTaxItem();
                    object = EbInterface60ToInvoiceConverter.createTaxCategoryVAT(ebi60TaxItemType.getTaxPercent().getTaxCategoryCode());
                    object.setPercent(ebi60TaxItemType.getTaxPercentValue());
                    object42.addTaxCategory((TaxCategoryType)object);
                }
                if (object3 != null) {
                    object42.setAmount((BigDecimal)object3).setCurrencyID(string);
                    if (object42.isChargeIndicatorValue(false)) {
                        object9 = ((BigDecimal)object9).add((BigDecimal)object3);
                    } else {
                        object82 = ((BigDecimal)object82).add((BigDecimal)object3);
                    }
                }
                invoiceType.addAllowanceCharge((AllowanceChargeType)object42);
            }
        }
        object7 = new TaxTotalType();
        object62 = BigDecimal.ZERO;
        for (Object object42 : ebi60InvoiceType.getTax().getTaxItem()) {
            object3 = new TaxSubtotalType();
            object3.setTaxableAmount(object42.getTaxableAmount()).setCurrencyID(string);
            object2 = object42.getTaxAmount() != null ? object42.getTaxAmount() : MathHelper.getPercentValue((BigDecimal)object42.getTaxableAmount(), (BigDecimal)object42.getTaxPercentValue());
            object3.setTaxAmount((BigDecimal)object2).setCurrencyID(string);
            TaxCategoryType taxCategoryType = EbInterface60ToInvoiceConverter.createTaxCategoryVAT(object42.getTaxPercent().getTaxCategoryCode());
            taxCategoryType.setPercent(object42.getTaxPercentValue());
            object3.setTaxCategory(taxCategoryType);
            object7.addTaxSubtotal(object3);
            if (object2 == null) continue;
            object62 = ((BigDecimal)object62).add((BigDecimal)object2);
        }
        for (Object object42 : ebi60InvoiceType.getTax().getOtherTax()) {
            object3 = new TaxSubtotalType();
            object3.setTaxAmount(object42.getTaxAmount()).setCurrencyID(string);
            object2 = EbInterface60ToInvoiceConverter.createTaxCategoryOther();
            if (StringHelper.hasText((String)object42.getComment())) {
                object2.getTaxScheme().setName(object42.getComment());
            }
            object3.setTaxCategory((TaxCategoryType)object2);
            object7.addTaxSubtotal(object3);
            object62 = ((BigDecimal)object62).add(object42.getTaxAmount());
        }
        object7.setTaxAmount((BigDecimal)object62).setCurrencyID(string);
        invoiceType.addTaxTotal((TaxTotalType)object7);
        object7 = BigDecimal.ZERO;
        for (Object object52 : invoiceType.getInvoiceLine()) {
            object7 = ((BigDecimal)object7).add(object52.getLineExtensionAmountValue());
        }
        object62 = new MonetaryTotalType();
        object62.setLineExtensionAmount((BigDecimal)object7).setCurrencyID(string);
        object62.setAllowanceTotalAmount((BigDecimal)object82).setCurrencyID(string);
        object62.setChargeTotalAmount((BigDecimal)object9).setCurrencyID(string);
        object62.setTaxExclusiveAmount((BigDecimal)object10).setCurrencyID(string);
        object62.setTaxInclusiveAmount(ebi60InvoiceType.getTotalGrossAmount()).setCurrencyID(string);
        object62.setPayableAmount(ebi60InvoiceType.getPayableAmount()).setCurrencyID(string);
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object62);
        if (StringHelper.hasText((String)ebi60InvoiceType.getComment())) {
            invoiceType.addNote(new NoteType(ebi60InvoiceType.getComment()));
        }
        return invoiceType;
    }
}

