/*
 * Decompiled with CFR 0.152.
 */
package at.austriapro.ebinterface.ubl.to;

import at.austriapro.ebinterface.ubl.to.AbstractEbInterface61ToUBLConverter;
import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.ebinterface.v61.Ebi61AccountType;
import com.helger.ebinterface.v61.Ebi61ArticleNumberType;
import com.helger.ebinterface.v61.Ebi61InvoiceType;
import com.helger.ebinterface.v61.Ebi61ItemListType;
import com.helger.ebinterface.v61.Ebi61OtherVATableTaxType;
import com.helger.ebinterface.v61.Ebi61PaymentConditionsType;
import com.helger.ebinterface.v61.Ebi61PaymentMethodType;
import com.helger.ebinterface.v61.Ebi61ReductionAndSurchargeBaseType;
import com.helger.ebinterface.v61.Ebi61ReductionAndSurchargeType;
import com.helger.ebinterface.v61.Ebi61SEPADirectDebitType;
import com.helger.ebinterface.v61.Ebi61TaxItemType;
import com.helger.ebinterface.v61.Ebi61UniversalBankTransactionType;
import java.math.BigDecimal;
import java.util.Locale;
import javax.annotation.Nonnull;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialInstitutionType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AdditionalAccountIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;

public class EbInterface61ToInvoiceConverter
extends AbstractEbInterface61ToUBLConverter {
    public EbInterface61ToInvoiceConverter(@Nonnull Locale locale, @Nonnull Locale locale2) {
        super(locale, locale2);
    }

    private static void _convertPayment(@Nonnull Ebi61InvoiceType ebi61InvoiceType, @Nonnull InvoiceType invoiceType) {
        Ebi61UniversalBankTransactionType ebi61UniversalBankTransactionType;
        Ebi61SEPADirectDebitType ebi61SEPADirectDebitType;
        Object object3;
        Object object2;
        Ebi61PaymentMethodType ebi61PaymentMethodType = ebi61InvoiceType.getPaymentMethod();
        Ebi61PaymentConditionsType ebi61PaymentConditionsType = ebi61InvoiceType.getPaymentConditions();
        if (ebi61PaymentMethodType != null && (object2 = ebi61PaymentMethodType.getNoPayment()) == null && (object3 = ebi61PaymentMethodType.getOtherPayment()) == null) {
            ebi61SEPADirectDebitType = ebi61PaymentMethodType.getSEPADirectDebit();
            if (ebi61SEPADirectDebitType != null) {
                ebi61UniversalBankTransactionType = new PaymentMeansType();
                ebi61UniversalBankTransactionType.setPaymentMeansCode("59");
                if (ebi61PaymentConditionsType != null) {
                    ebi61UniversalBankTransactionType.setPaymentDueDate(ebi61PaymentConditionsType.getDueDate());
                }
                if (StringHelper.hasText((String)ebi61PaymentMethodType.getComment())) {
                    ebi61UniversalBankTransactionType.addInstructionNote(new InstructionNoteType(ebi61PaymentMethodType.getComment()));
                }
                invoiceType.addPaymentMeans((PaymentMeansType)ebi61UniversalBankTransactionType);
            } else {
                ebi61UniversalBankTransactionType = ebi61PaymentMethodType.getUniversalBankTransaction();
                if (ebi61UniversalBankTransactionType != null) {
                    PaymentMeansType paymentMeansType = new PaymentMeansType();
                    paymentMeansType.setPaymentMeansCode("30");
                    paymentMeansType.setPaymentChannelCode("IBAN");
                    if (ebi61UniversalBankTransactionType.hasBeneficiaryAccountEntries()) {
                        Ebi61AccountType ebi61AccountType = ebi61UniversalBankTransactionType.getBeneficiaryAccountAtIndex(0);
                        FinancialAccountType financialAccountType = new FinancialAccountType();
                        BranchType branchType = new BranchType();
                        FinancialInstitutionType financialInstitutionType = new FinancialInstitutionType();
                        IDType iDType = new IDType();
                        if (StringHelper.hasText((String)ebi61AccountType.getBIC())) {
                            iDType.setValue(ebi61AccountType.getBIC());
                            iDType.setSchemeID("BIC");
                        } else if (ebi61AccountType.getBankCode() != null) {
                            iDType.setValue(ebi61AccountType.getBankCode().getValue().toString());
                            iDType.setSchemeID(ebi61AccountType.getBankCode().getBankCodeType());
                        } else if (StringHelper.hasText((String)ebi61AccountType.getBankName())) {
                            iDType.setValue(ebi61AccountType.getBankName());
                            iDType.setSchemeID("name");
                        }
                        if (StringHelper.hasText((String)iDType.getValue())) {
                            financialInstitutionType.setID(iDType);
                        }
                        if (financialInstitutionType.getID() != null) {
                            branchType.setFinancialInstitution(financialInstitutionType);
                        }
                        iDType = new IDType();
                        if (StringHelper.hasText((String)ebi61AccountType.getIBAN())) {
                            iDType.setValue(ebi61AccountType.getIBAN());
                            iDType.setSchemeID("IBAN");
                        } else if (StringHelper.hasText((String)ebi61AccountType.getBankAccountNr())) {
                            iDType.setValue(ebi61AccountType.getBankAccountNr());
                            iDType.setSchemeID("local");
                        }
                        if (StringHelper.hasText((String)iDType.getValue())) {
                            financialAccountType.setID(iDType);
                        }
                        financialAccountType.setName(ebi61AccountType.getBankAccountOwner());
                        if (branchType.getFinancialInstitution() != null) {
                            financialAccountType.setFinancialInstitutionBranch(branchType);
                        }
                        paymentMeansType.setPayeeFinancialAccount(financialAccountType);
                    }
                    if (ebi61UniversalBankTransactionType.getPaymentReference() != null) {
                        paymentMeansType.setInstructionID(new InstructionIDType(ebi61UniversalBankTransactionType.getPaymentReference().getValue()));
                    }
                    if (ebi61PaymentConditionsType != null) {
                        paymentMeansType.setPaymentDueDate(ebi61PaymentConditionsType.getDueDate());
                    }
                    if (StringHelper.hasText((String)ebi61PaymentMethodType.getComment())) {
                        paymentMeansType.addInstructionNote(new InstructionNoteType(ebi61PaymentMethodType.getComment()));
                    }
                    invoiceType.addPaymentMeans(paymentMeansType);
                } else {
                    throw new IllegalStateException("Unsupported payment method present!");
                }
            }
        }
        if (ebi61PaymentConditionsType != null) {
            object2 = new PaymentTermsType();
            object2.setPaymentDueDate(ebi61PaymentConditionsType.getDueDate());
            if (ebi61PaymentConditionsType.getMinimumPayment() != null) {
                object3 = MathHelper.isEQ0((BigDecimal)ebi61InvoiceType.getPayableAmount()) ? BigDecimal.ZERO : ebi61PaymentConditionsType.getMinimumPayment().divide(ebi61InvoiceType.getPayableAmount(), 4, ROUNDING_MODE).multiply(CGlobal.BIGDEC_100);
                object2.setPaymentPercent((BigDecimal)object3);
            }
            if (StringHelper.hasText((String)ebi61PaymentConditionsType.getComment())) {
                object2.addNote(new NoteType(ebi61PaymentConditionsType.getComment()));
            }
            invoiceType.addPaymentTerms((PaymentTermsType)object2);
            for (Object object3 : ebi61PaymentConditionsType.getDiscount()) {
                ebi61SEPADirectDebitType = new PaymentTermsType();
                ebi61UniversalBankTransactionType = new PeriodType();
                ebi61UniversalBankTransactionType.setEndDate(object3.getPaymentDate());
                ebi61SEPADirectDebitType.setSettlementPeriod((PeriodType)ebi61UniversalBankTransactionType);
                if (object3.getBaseAmount() != null) {
                    ebi61SEPADirectDebitType.setAmount(object3.getBaseAmount()).setCurrencyID(ebi61InvoiceType.getInvoiceCurrency());
                }
                ebi61SEPADirectDebitType.setSettlementDiscountPercent(object3.getPercentage());
                if (object3.getAmount() != null) {
                    ebi61SEPADirectDebitType.setSettlementDiscountAmount(object3.getAmount()).setCurrencyID(ebi61InvoiceType.getInvoiceCurrency());
                }
                if (StringHelper.hasText((String)object3.getComment())) {
                    ebi61SEPADirectDebitType.addNote(new NoteType(object3.getComment()));
                }
                invoiceType.addPaymentTerms((PaymentTermsType)ebi61SEPADirectDebitType);
            }
        }
    }

    @Nonnull
    public InvoiceType convertInvoice(@Nonnull Ebi61InvoiceType ebi61InvoiceType) {
        Object object;
        Object object2;
        Object object3;
        Ebi61TaxItemType ebi61TaxItemType2;
        PriceType priceType2;
        Object object42;
        Object object52;
        Object object6;
        Ebi61ItemListType ebi61ItemListType2;
        Object object7;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType22;
        ValueEnforcer.notNull((Object)ebi61InvoiceType, (String)"ebInterfaceDocument");
        String string = ebi61InvoiceType.getInvoiceCurrency();
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setUBLVersionID("2.1");
        invoiceType.setInvoiceTypeCode(EbInterface61ToInvoiceConverter.getTypeCode(ebi61InvoiceType.getDocumentType(), InvoiceTypeCodeType::new));
        DocumentCurrencyCodeType documentCurrencyCodeType = invoiceType.setDocumentCurrencyCode(string);
        documentCurrencyCodeType.setListAgencyID("6");
        documentCurrencyCodeType.setListID("ISO 4217 Alpha");
        if (ebi61InvoiceType.isIsDuplicate() != null) {
            invoiceType.setCopyIndicator(ebi61InvoiceType.isIsDuplicate().booleanValue());
        }
        invoiceType.setID(ebi61InvoiceType.getInvoiceNumber());
        invoiceType.setIssueDate(ebi61InvoiceType.getInvoiceDate());
        Object object8 = ebi61InvoiceType.getCancelledOriginalDocument();
        if (object8 != null) {
            documentReferenceType22 = new DocumentReferenceType();
            documentReferenceType22.setID(object8.getInvoiceNumber());
            documentReferenceType22.setIssueDate(object8.getInvoiceDate());
            documentReferenceType22.setDocumentType("CancelledOriginalDocument");
            documentReferenceType22.setDocumentTypeCode(EbInterface61ToInvoiceConverter.getTypeCode(object8.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)object8.getComment())) {
                documentReferenceType22.addDocumentDescription(new DocumentDescriptionType(object8.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType22);
        }
        for (DocumentReferenceType documentReferenceType22 : ebi61InvoiceType.getRelatedDocument()) {
            documentReferenceType = new DocumentReferenceType();
            documentReferenceType.setID(documentReferenceType22.getInvoiceNumber());
            documentReferenceType.setIssueDate(documentReferenceType22.getInvoiceDate());
            documentReferenceType.setDocumentType("RelatedDocument");
            documentReferenceType.setDocumentTypeCode(EbInterface61ToInvoiceConverter.getTypeCode(documentReferenceType22.getDocumentType(), DocumentTypeCodeType::new));
            if (StringHelper.hasText((String)documentReferenceType22.getComment())) {
                documentReferenceType.addDocumentDescription(new DocumentDescriptionType(documentReferenceType22.getComment()));
            }
            invoiceType.addAdditionalDocumentReference(documentReferenceType);
        }
        object8 = EbInterface61ToInvoiceConverter.convertDelivery(ebi61InvoiceType.getDelivery(), this.m_aContentLocale);
        if (object8 != null) {
            if (invoiceType.getInvoicePeriodCount() == 0 && object8.getRequestedDeliveryPeriod() != null) {
                invoiceType.addInvoicePeriod(object8.getRequestedDeliveryPeriod());
            }
            invoiceType.addDelivery((DeliveryType)object8);
        }
        if ((object8 = ebi61InvoiceType.getBiller()) != null) {
            documentReferenceType22 = new SupplierPartyType();
            documentReferenceType = EbInterface61ToInvoiceConverter.convertParty(object8.getAddress(), object8.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface61ToInvoiceConverter.createTaxSchemeVAT());
                ebi61ItemListType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                ebi61ItemListType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getInvoiceRecipientsBillerID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setCustomerAssignedAccountID(object8.getInvoiceRecipientsBillerID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getInvoiceRecipientsBillerID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Ebi61ItemListType ebi61ItemListType2 : object8.getFurtherIdentification()) {
                object6 = new DocumentReferenceType();
                object52 = new IDType();
                object52.setValue(ebi61ItemListType2.getValue());
                object52.setSchemeID(ebi61ItemListType2.getIdentificationType());
                object6.setID((IDType)object52);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object6);
            }
            invoiceType.setAccountingSupplierParty((SupplierPartyType)documentReferenceType22);
        }
        if ((object8 = ebi61InvoiceType.getInvoiceRecipient()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface61ToInvoiceConverter.convertParty(object8.getAddress(), object8.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface61ToInvoiceConverter.createTaxSchemeVAT());
                ebi61ItemListType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                ebi61ItemListType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getBillersInvoiceRecipientID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object8.getBillersInvoiceRecipientID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getBillersInvoiceRecipientID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Ebi61ItemListType ebi61ItemListType2 : object8.getFurtherIdentification()) {
                object6 = new AdditionalAccountIDType();
                object6.setValue(ebi61ItemListType2.getValue());
                object6.setSchemeID(ebi61ItemListType2.getIdentificationType());
                documentReferenceType22.addAdditionalAccountID((AdditionalAccountIDType)object6);
            }
            object7 = object8.getOrderReference();
            if (object7 != null) {
                ebi61ItemListType2 = new OrderReferenceType();
                ebi61ItemListType2.setID(object7.getOrderID());
                if (object7.getReferenceDate() != null) {
                    ebi61ItemListType2.setIssueDate(object7.getReferenceDate());
                }
                invoiceType.setOrderReference((OrderReferenceType)ebi61ItemListType2);
            }
            invoiceType.setAccountingCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        if ((object8 = ebi61InvoiceType.getOrderingParty()) != null) {
            documentReferenceType22 = new CustomerPartyType();
            documentReferenceType = EbInterface61ToInvoiceConverter.convertParty(object8.getAddress(), object8.getContact(), this.m_aContentLocale);
            if (StringHelper.hasText((String)object8.getVATIdentificationNumber())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                object7 = new PartyTaxSchemeType();
                object7.setTaxScheme(EbInterface61ToInvoiceConverter.createTaxSchemeVAT());
                ebi61ItemListType2 = object7.setCompanyID(object8.getVATIdentificationNumber());
                ebi61ItemListType2.setSchemeID("VAT");
                documentReferenceType.addPartyTaxScheme((PartyTaxSchemeType)object7);
            }
            if (StringHelper.hasText((String)object8.getBillersOrderingPartyID())) {
                if (documentReferenceType == null) {
                    documentReferenceType = new PartyType();
                }
                documentReferenceType22.setSupplierAssignedAccountID(object8.getBillersOrderingPartyID());
                object7 = new PartyIdentificationType();
                object7.setID(object8.getBillersOrderingPartyID());
                documentReferenceType.addPartyIdentification((PartyIdentificationType)object7);
            }
            documentReferenceType22.setParty((PartyType)documentReferenceType);
            for (Ebi61ItemListType ebi61ItemListType2 : object8.getFurtherIdentification()) {
                object6 = new DocumentReferenceType();
                object52 = new IDType();
                object52.setValue(ebi61ItemListType2.getValue());
                object52.setSchemeID(ebi61ItemListType2.getIdentificationType());
                object6.setID((IDType)object52);
                invoiceType.addContractDocumentReference((DocumentReferenceType)object6);
            }
            invoiceType.setBuyerCustomerParty((CustomerPartyType)documentReferenceType22);
        }
        object8 = BigDecimal.ZERO;
        documentReferenceType22 = ebi61InvoiceType.getDetails();
        int n = 1;
        for (Ebi61ItemListType ebi61ItemListType2 : documentReferenceType22.getItemList()) {
            for (Object object52 : ebi61ItemListType2.getListLineItem()) {
                Ebi61OtherVATableTaxType ebi61OtherVATableTaxType;
                AllowanceChargeType allowanceChargeType;
                Object object9;
                String string22;
                object42 = new InvoiceLineType();
                object42.setID(object52.getPositionNumber() != null ? object52.getPositionNumber().toString() : Integer.toString(n));
                priceType2 = StringHelper.trim((String)object52.getQuantity().getUnit());
                if (priceType2 == null) {
                    priceType2 = "C62";
                }
                object42.setInvoicedQuantity(object52.getQuantity().getValue()).setUnitCode(priceType2);
                object42.setLineExtensionAmount(object52.getLineItemAmount()).setCurrencyID(string);
                ebi61TaxItemType2 = new PriceType();
                ebi61TaxItemType2.setPriceAmount(object52.getUnitPrice().getValue()).setCurrencyID(string);
                if (object52.getUnitPrice().getBaseQuantity() != null) {
                    ebi61TaxItemType2.setBaseQuantity(object52.getUnitPrice().getBaseQuantity());
                }
                object42.setPrice((PriceType)ebi61TaxItemType2);
                if (object52.getDelivery() != null) {
                    object42.addDelivery(EbInterface61ToInvoiceConverter.convertDelivery(object52.getDelivery(), this.m_aContentLocale));
                }
                object3 = new ItemType();
                for (String string22 : object52.getDescription()) {
                    object3.addDescription(new DescriptionType(string22));
                }
                object3.setPackSizeNumeric(BigDecimal.ONE);
                object2 = object52.getTaxItem();
                string22 = EbInterface61ToInvoiceConverter.createTaxCategoryVAT(object2.getTaxPercent().getTaxCategoryCode());
                string22.setPercent(object2.getTaxPercentValue());
                object3.addClassifiedTaxCategory((TaxCategoryType)string22);
                if (object52.getReductionAndSurchargeListLineItemDetails() != null) {
                    for (Ebi61ArticleNumberType ebi61ArticleNumberType : object52.getReductionAndSurchargeListLineItemDetails().getReductionListLineItemOrSurchargeListLineItemOrOtherVATableTaxListLineItem()) {
                        object9 = ebi61ArticleNumberType.getValue();
                        allowanceChargeType = new AllowanceChargeType();
                        if (object9 instanceof Ebi61OtherVATableTaxType) {
                            ebi61OtherVATableTaxType = (Ebi61OtherVATableTaxType)object9;
                            allowanceChargeType.setChargeIndicator(true);
                            allowanceChargeType.setBaseAmount(ebi61OtherVATableTaxType.getTaxableAmount()).setCurrencyID(string);
                            allowanceChargeType.setMultiplierFactorNumeric(ebi61OtherVATableTaxType.getTaxPercentValue().divide(CGlobal.BIGDEC_100));
                            if (ebi61OtherVATableTaxType.getTaxAmount() != null) {
                                allowanceChargeType.setAmount(ebi61OtherVATableTaxType.getTaxAmount()).setCurrencyID(string);
                            } else {
                                allowanceChargeType.setAmount(MathHelper.getPercentValue((BigDecimal)ebi61OtherVATableTaxType.getTaxableAmount(), (BigDecimal)ebi61OtherVATableTaxType.getTaxPercentValue())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi61OtherVATableTaxType.getTaxID())) {
                                allowanceChargeType.setAllowanceChargeReasonCode(ebi61OtherVATableTaxType.getTaxID());
                            }
                            if (StringHelper.hasText((String)ebi61OtherVATableTaxType.getComment())) {
                                allowanceChargeType.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi61OtherVATableTaxType.getComment()));
                            }
                        } else {
                            ebi61OtherVATableTaxType = (Ebi61ReductionAndSurchargeBaseType)object9;
                            boolean bl = ebi61ArticleNumberType.getName().getLocalPart().equals("ReductionListLineItem");
                            allowanceChargeType.setChargeIndicator(!bl);
                            allowanceChargeType.setBaseAmount(ebi61OtherVATableTaxType.getBaseAmount()).setCurrencyID(string);
                            if (ebi61OtherVATableTaxType.getPercentage() != null) {
                                allowanceChargeType.setMultiplierFactorNumeric(ebi61OtherVATableTaxType.getPercentage().divide(CGlobal.BIGDEC_100));
                            }
                            if (ebi61OtherVATableTaxType.getAmount() != null) {
                                allowanceChargeType.setAmount(ebi61OtherVATableTaxType.getAmount()).setCurrencyID(string);
                            } else if (ebi61OtherVATableTaxType.getPercentage() != null) {
                                allowanceChargeType.setAmount(MathHelper.getPercentValue((BigDecimal)ebi61OtherVATableTaxType.getBaseAmount(), (BigDecimal)ebi61OtherVATableTaxType.getPercentage())).setCurrencyID(string);
                            }
                            if (StringHelper.hasText((String)ebi61OtherVATableTaxType.getComment())) {
                                allowanceChargeType.addAllowanceChargeReason(new AllowanceChargeReasonType(ebi61OtherVATableTaxType.getComment()));
                            }
                        }
                        if (allowanceChargeType.getAmount() == null) continue;
                        object42.addAllowanceCharge(allowanceChargeType);
                    }
                }
                for (Ebi61ArticleNumberType ebi61ArticleNumberType : object52.getArticleNumber()) {
                    object9 = new ItemIdentificationType();
                    object9.setID(ebi61ArticleNumberType.getValue());
                    if (ebi61ArticleNumberType.getArticleNumberType() != null) {
                        allowanceChargeType = new PartyType();
                        ebi61OtherVATableTaxType = new PartyIdentificationType();
                        ebi61OtherVATableTaxType.setID(ebi61ArticleNumberType.getArticleNumberType().value());
                        allowanceChargeType.addPartyIdentification((PartyIdentificationType)ebi61OtherVATableTaxType);
                        object9.setIssuerParty((PartyType)allowanceChargeType);
                    }
                    object3.addManufacturersItemIdentification((ItemIdentificationType)object9);
                }
                for (Ebi61ArticleNumberType ebi61ArticleNumberType : object52.getAdditionalInformation()) {
                    object3.addAdditionalItemProperty(EbInterface61ToInvoiceConverter.createItemProperty(ebi61ArticleNumberType.getKey(), ebi61ArticleNumberType.getValue()));
                }
                object42.setItem((ItemType)object3);
                object3 = object52.getInvoiceRecipientsOrderReference();
                if (object3 != null) {
                    object2 = new OrderLineReferenceType();
                    boolean bl = false;
                    object = new OrderReferenceType();
                    boolean bl2 = false;
                    if (object3.getOrderID() != null) {
                        object.setID(object3.getOrderID());
                        bl2 = true;
                    }
                    if (object3.getReferenceDate() != null) {
                        object.setIssueDate(object3.getReferenceDate());
                        bl2 = true;
                    }
                    if (bl2) {
                        object2.setOrderReference((OrderReferenceType)object);
                        bl = true;
                    }
                    if (object3.getOrderPositionNumber() != null) {
                        object2.setLineID(object3.getOrderPositionNumber());
                        bl = true;
                    }
                    if (bl) {
                        object42.addOrderLineReference((OrderLineReferenceType)object2);
                    }
                }
                invoiceType.addInvoiceLine((InvoiceLineType)object42);
                object8 = ((BigDecimal)object8).add(object52.getLineItemAmount());
                ++n;
            }
        }
        object7 = BigDecimal.ZERO;
        int n2 = 1;
        for (Object object52 : documentReferenceType22.getBelowTheLineItem()) {
            object42 = new InvoiceLineType();
            object42.setID("BTL" + n2);
            object42.addNote(new NoteType("BelowTheLineItem"));
            object42.setInvoicedQuantity(BigDecimal.ONE).setUnitCode("C62");
            object42.setLineExtensionAmount(object52.getLineItemAmount()).setCurrencyID(string);
            priceType2 = new PriceType();
            priceType2.setPriceAmount(object52.getLineItemAmount()).setCurrencyID(string);
            priceType2.setBaseQuantity(BigDecimal.ONE);
            object42.setPrice(priceType2);
            ebi61TaxItemType2 = new ItemType();
            if (StringHelper.hasText((String)object52.getDescription())) {
                ebi61TaxItemType2.addDescription(new DescriptionType(object52.getDescription()));
            }
            ebi61TaxItemType2.setPackSizeNumeric(BigDecimal.ONE);
            object3 = EbInterface61ToInvoiceConverter.createTaxCategoryVAT("E");
            object3.setPercent(BigDecimal.ZERO);
            object3.addTaxExemptionReason(new TaxExemptionReasonType("BelowTheLine - tax already handled"));
            ebi61TaxItemType2.addClassifiedTaxCategory((TaxCategoryType)object3);
            object42.setItem((ItemType)ebi61TaxItemType2);
            invoiceType.addInvoiceLine((InvoiceLineType)object42);
            object8 = ((BigDecimal)object8).add(object52.getLineItemAmount());
            object7 = ((BigDecimal)object7).add(object52.getLineItemAmount());
            ++n2;
        }
        EbInterface61ToInvoiceConverter._convertPayment(ebi61InvoiceType, invoiceType);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        object6 = BigDecimal.ZERO;
        if (ebi61InvoiceType.getReductionAndSurchargeDetails() != null) {
            for (Object object42 : ebi61InvoiceType.getReductionAndSurchargeDetails().getReductionOrSurchargeOrOtherVATableTax()) {
                priceType2 = object42.getValue();
                ebi61TaxItemType2 = new AllowanceChargeType();
                if (priceType2 instanceof Ebi61OtherVATableTaxType) {
                    object2 = (Ebi61OtherVATableTaxType)priceType2;
                    ebi61TaxItemType2.setChargeIndicator(true);
                    ebi61TaxItemType2.setBaseAmount(object2.getTaxableAmount()).setCurrencyID(string);
                    ebi61TaxItemType2.setMultiplierFactorNumeric(object2.getTaxPercentValue().divide(CGlobal.BIGDEC_100));
                    object3 = object2.getTaxAmount() != null ? object2.getTaxAmount() : MathHelper.getPercentValue((BigDecimal)object2.getTaxableAmount(), (BigDecimal)object2.getTaxPercentValue());
                    if (StringHelper.hasText((String)object2.getTaxID())) {
                        ebi61TaxItemType2.setAllowanceChargeReasonCode(object2.getTaxID());
                    }
                    if (StringHelper.hasText((String)object2.getComment())) {
                        ebi61TaxItemType2.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    TaxCategoryType taxCategoryType = EbInterface61ToInvoiceConverter.createTaxCategoryOther();
                    taxCategoryType.setPercent(object2.getTaxPercentValue());
                    ebi61TaxItemType2.addTaxCategory(taxCategoryType);
                } else {
                    object2 = (Ebi61ReductionAndSurchargeType)priceType2;
                    boolean bl = object42.getName().getLocalPart().equals("Reduction");
                    ebi61TaxItemType2.setChargeIndicator(!bl);
                    ebi61TaxItemType2.setBaseAmount(object2.getBaseAmount()).setCurrencyID(string);
                    if (object2.getPercentage() != null) {
                        ebi61TaxItemType2.setMultiplierFactorNumeric(object2.getPercentage().divide(CGlobal.BIGDEC_100));
                    }
                    object3 = object2.getAmount() != null ? object2.getAmount() : MathHelper.getPercentValue((BigDecimal)object2.getBaseAmount(), (BigDecimal)object2.getPercentage());
                    if (StringHelper.hasText((String)object2.getComment())) {
                        ebi61TaxItemType2.addAllowanceChargeReason(new AllowanceChargeReasonType(object2.getComment()));
                    }
                    object = object2.getTaxItem();
                    TaxCategoryType taxCategoryType = EbInterface61ToInvoiceConverter.createTaxCategoryVAT(object.getTaxPercent().getTaxCategoryCode());
                    taxCategoryType.setPercent(object.getTaxPercentValue());
                    ebi61TaxItemType2.addTaxCategory(taxCategoryType);
                }
                if (object3 != null) {
                    ebi61TaxItemType2.setAmount((BigDecimal)object3).setCurrencyID(string);
                    if (ebi61TaxItemType2.isChargeIndicatorValue(false)) {
                        bigDecimal = bigDecimal.add((BigDecimal)object3);
                    } else {
                        object6 = ((BigDecimal)object6).add((BigDecimal)object3);
                    }
                }
                invoiceType.addAllowanceCharge((AllowanceChargeType)ebi61TaxItemType2);
            }
        }
        object52 = new TaxTotalType();
        object42 = BigDecimal.ZERO;
        for (Ebi61TaxItemType ebi61TaxItemType2 : ebi61InvoiceType.getTax().getTaxItem()) {
            object3 = new TaxSubtotalType();
            object3.setTaxableAmount(ebi61TaxItemType2.getTaxableAmount()).setCurrencyID(string);
            object2 = ebi61TaxItemType2.getTaxAmount() != null ? ebi61TaxItemType2.getTaxAmount() : MathHelper.getPercentValue((BigDecimal)ebi61TaxItemType2.getTaxableAmount(), (BigDecimal)ebi61TaxItemType2.getTaxPercentValue());
            object3.setTaxAmount((BigDecimal)object2).setCurrencyID(string);
            TaxCategoryType taxCategoryType = EbInterface61ToInvoiceConverter.createTaxCategoryVAT(ebi61TaxItemType2.getTaxPercent().getTaxCategoryCode());
            taxCategoryType.setPercent(ebi61TaxItemType2.getTaxPercentValue());
            object3.setTaxCategory(taxCategoryType);
            object52.addTaxSubtotal(object3);
            if (object2 == null) continue;
            object42 = ((BigDecimal)object42).add((BigDecimal)object2);
        }
        for (Ebi61TaxItemType ebi61TaxItemType2 : ebi61InvoiceType.getTax().getOtherTax()) {
            object3 = new TaxSubtotalType();
            object3.setTaxAmount(ebi61TaxItemType2.getTaxAmount()).setCurrencyID(string);
            object2 = EbInterface61ToInvoiceConverter.createTaxCategoryOther();
            if (StringHelper.hasText((String)ebi61TaxItemType2.getComment())) {
                object2.getTaxScheme().setName(ebi61TaxItemType2.getComment());
            }
            object3.setTaxCategory((TaxCategoryType)object2);
            object52.addTaxSubtotal(object3);
            object42 = ((BigDecimal)object42).add(ebi61TaxItemType2.getTaxAmount());
        }
        object52.setTaxAmount((BigDecimal)object42).setCurrencyID(string);
        invoiceType.addTaxTotal((TaxTotalType)object52);
        object52 = BigDecimal.ZERO;
        for (PriceType priceType2 : invoiceType.getInvoiceLine()) {
            object52 = ((BigDecimal)object52).add(priceType2.getLineExtensionAmountValue());
        }
        object42 = new MonetaryTotalType();
        object42.setLineExtensionAmount((BigDecimal)object52).setCurrencyID(string);
        object42.setAllowanceTotalAmount((BigDecimal)object6).setCurrencyID(string);
        object42.setChargeTotalAmount(bigDecimal).setCurrencyID(string);
        object42.setTaxExclusiveAmount((BigDecimal)object8).setCurrencyID(string);
        object42.setTaxInclusiveAmount(ebi61InvoiceType.getTotalGrossAmount()).setCurrencyID(string);
        object42.setPayableAmount(ebi61InvoiceType.getPayableAmount()).setCurrencyID(string);
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object42);
        if (StringHelper.hasText((String)ebi61InvoiceType.getComment())) {
            invoiceType.addNote(new NoteType(ebi61InvoiceType.getComment()));
        }
        return invoiceType;
    }
}

