/*
 * Decompiled with CFR 0.152.
 */
package at.bestsolution.maven.shade;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class ManifestTransformer
implements ResourceTransformer {
    private Manifest m;
    private String mainClass;
    private Map<String, Object> manifestEntries;
    private Map<String, String> concatEntries;

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        if (this.m == null) {
            this.m = new Manifest();
            if (this.mainClass != null) {
                this.m.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.mainClass);
            }
            if (this.manifestEntries != null) {
                this.manifestEntries.entrySet().forEach(e -> this.m.getMainAttributes().put(new Attributes.Name((String)e.getKey()), e.getValue()));
            }
            this.m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            this.m.getMainAttributes().put(new Attributes.Name("Created-By"), System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            this.m.getMainAttributes().put(new Attributes.Name("Tool"), "e(fx)clipse shade transformer");
        }
        if (this.concatEntries != null) {
            Manifest mm = new Manifest(is);
            Attributes attributes = mm.getMainAttributes();
            for (Map.Entry<String, String> entry : this.concatEntries.entrySet()) {
                String serviceComponents = attributes.getValue(new Attributes.Name(entry.getKey()));
                if (serviceComponents == null) continue;
                String value = this.m.getMainAttributes().getValue(new Attributes.Name(entry.getKey()));
                value = value == null ? serviceComponents : value + entry.getValue() + serviceComponents;
                this.m.getMainAttributes().put(new Attributes.Name(entry.getKey()), value);
            }
        }
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.m.write(jos);
    }

    public boolean hasTransformedResource() {
        return true;
    }
}

