package at.datenwort.commons.agentsFromService.impl;

import at.datenwort.commons.agentsFromService.api.AgentConfigurator;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.builder.AgentBuilder;

import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.ServiceLoader;

public final class ServiceInstrumentationAgent {
    private static volatile boolean installed = false;

    private ServiceInstrumentationAgent() {
    }

    public synchronized static void install() {
        if (installed) {
            return;
        }

        Instrumentation instrumentation = ByteBuddyAgent.install();
        installed = true;

        premain(null, instrumentation);
    }

    public static void premain(String args, Instrumentation instrumentation) {
        AgentBuilder builder = new AgentBuilder.Default()
                .with(new AgentBuilder.Listener.WithErrorsOnly(new AgentBuilder.Listener.StreamWriting(System.err)));

        List<AgentConfigurator> agentConfigurators = ServiceLoader.load(AgentConfigurator.class)
                .stream()
                .map(ServiceLoader.Provider::get)
                .sorted((a1, a2) -> {
                    int o1 = a1.getOrder();
                    int o2 = a2.getOrder();
                    if (o1 < o2) {
                        return -1;
                    }
                    if (o1 > o2) {
                        return 1;
                    }

                    return a1.getClass()
                            .getName()
                            .compareTo(a2.getClass()
                                    .getName());
                })
                .toList();

        for (AgentConfigurator configurator : agentConfigurators) {
            builder = configurator.install(builder);
        }

        builder.installOn(instrumentation);
    }
}
