package at.datenwort.firstClass.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Default property getter which might make a field accessible using reflection.
 */
public class DefaultPropertyGetter implements PropertyGetter {
    @Override
    public <T> T getField(FcProperty<T> property, Field field, Object obj) throws IllegalAccessException {
        if (!field.canAccess(obj)) {
            field.setAccessible(true);
        }

        Object ret = field.get(obj);
        //noinspection unchecked
        return (T) ret;
    }

    @Override
    public <T> T getFieldMethod(FcProperty<T> property, Method method, Object obj) throws IllegalAccessException, InvocationTargetException {
        Object ret = method.invoke(obj);
        //noinspection unchecked
        return (T) ret;
    }
}
