package at.datenwort.firstClass.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Default property setter which might make a field accessible using reflection.
 */
public class DefaultPropertySetter implements PropertySetter {
    @Override
    public <T> void setField(FcProperty<T> property, Field field, Object obj, T value) throws IllegalAccessException {
        if (!field.canAccess(obj)) {
            field.setAccessible(true);
        }

        if (obj instanceof PropertySupportInterface propertySupportInterface) {
            Object oldValue = field.get(obj);
            field.set(obj, value);

            // The weaver is not able to intercept such writes. Therefore, we have to fire
            // an event also.
            propertySupportInterface.firePropertyChange(
                    field.getName(),
                    oldValue,
                    value,
                    false);
        } else {
            field.set(obj, value);
        }
    }

    @Override
    public <T> void setFieldMethod(FcProperty<T> property, Method method, Object obj, T value) throws IllegalAccessException, InvocationTargetException {
        method.invoke(obj, value);
    }
}
