package at.datenwort.firstClass.runtime;

import java.beans.PropertyChangeListener;

@SuppressWarnings("unused")
public final class FcUtils {
    private FcUtils() {
    }

    public static void addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (!(object instanceof PropertySupportInterface propertySupportInterface)) {
            throw new IllegalArgumentException(object + " not implementing PropertySupportInterface");
        }

        propertySupportInterface.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        if (!(object instanceof PropertySupportInterface propertySupportInterface)) {
            throw new IllegalArgumentException(object + " not implementing PropertySupportInterface");
        }

        propertySupportInterface.removePropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(Object object, String propertyName, PropertyChangeListener listener) {
        if (!(object instanceof PropertySupportInterface propertySupportInterface)) {
            throw new IllegalArgumentException(object + " not implementing PropertySupportInterface");
        }

        propertySupportInterface.addPropertyChangeListener(propertyName, listener);
    }

    public static void removePropertyChangeListener(Object object, String propertyName, PropertyChangeListener listener) {
        if (!(object instanceof PropertySupportInterface propertySupportInterface)) {
            throw new IllegalArgumentException(object + " not implementing PropertySupportInterface");
        }

        propertySupportInterface.removePropertyChangeListener(propertyName, listener);
    }

    public static <T> FirstClass<T> getFirstClassRequired(Class<T> beanClass) {
        FirstClass<T> ret = getFirstClass(beanClass);
        if (ret == null) {
            throw new IllegalArgumentException("Class " + (beanClass != null ? beanClass.getName() : "#null?") + " has no FirstClass-Properties structure.");
        }
        return ret;
    }

    public static <T> FirstClass<T> getFirstClass(Class<T> beanClass) {
        if (beanClass == null) {
            return null;
        }

        try {
            //noinspection unchecked
            FirstClass<T> fc = (FirstClass<T>) beanClass.getField("p")
                    .get(null);
            return fc;
        } catch (NoSuchFieldException | IllegalAccessException e) {
            return null;
        }
    }

    /**
     * find property for the given property path
     */
    public static <DUMMY> FcProperty<DUMMY> findProperty(FirstClass<?> fcBase, String propertyName) {
        if (fcBase == null) {
            return null;
        }

        FcProperty<?> property = fcBase;
        FirstClass<?> fc = fcBase;
        for (String propNamePart : propertyName.split("\\.")) {
            FcProperty<?> prop = fc.findProperty(propNamePart);
            if (prop == null) {
                return null;
            }

            if (prop instanceof FirstClass<?> firstClass) {
                fc = firstClass;
            }

            property = prop;
        }

        //noinspection unchecked
        return (FcProperty<DUMMY>) property;
    }

    static Class<?> getFcOwnerClass(Class<?> fcClass) {
        Class<?> fcOwner = (Class<?>) fcClass.getTypeParameters()[0].getBounds()[0];

        return fcOwner;
    }
}
