package at.datenwort.firstClass.runtime;

import java.util.Comparator;

public class PropertyChangeListenerEventComparator implements Comparator<PropertyChangeListenerEvent> {
    public final static PropertyChangeListenerEventComparator INSTANCE = new PropertyChangeListenerEventComparator();

    private PropertyChangeListenerEventComparator() {
    }

    @Override
    public int compare(PropertyChangeListenerEvent o1, PropertyChangeListenerEvent o2) {
        int ret = o1.getPropertyName()
                .compareTo(o2.getPropertyName());
        if (ret != 0) {
            return ret;
        }

        ret = Integer.compare(o1.getOrder(), o2.getOrder());
        return ret;
    }
}
