package at.datenwort.firstClass.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * <p>The property getter used to get the value for a field</p>
 * <p>Override by configuring a service using <code>/META-INF/services/at.datenwort.firstClass.runtime.PropertyGetter</code></p>
 */
public interface PropertyGetter {
    <T> T getField(FcProperty<T> property, Field field, Object obj) throws IllegalAccessException;

    <T> T getFieldMethod(FcProperty<T> property, Method method, Object obj) throws IllegalAccessException, InvocationTargetException;
}
