package at.datenwort.firstClass.runtime.aspect;

import at.datenwort.firstClass.runtime.PropertySupportInterface;
import at.datenwort.firstClass.runtime.annotations.IgnoreParentHandling;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;

@SuppressWarnings("unused")
public class PropertyChangeSupportSetFieldInterceptor {
    public static boolean intercept(final boolean newValue, final boolean oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static byte intercept(final byte newValue, final byte oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static short intercept(final short newValue, final short oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static int intercept(final int newValue, final int oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static long intercept(final long newValue, final long oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static float intercept(final float newValue, final float oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    public static double intercept(final double newValue, final double oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    @RuntimeType
    public static <T> T intercept(final T newValue, final T oldValue, final PropertySupportInterface target, String fieldName, boolean registerOnly) {
        _intercept(target, fieldName, oldValue, newValue, registerOnly);
        return newValue;
    }

    private static <T> void _intercept(final PropertySupportInterface target, final String fieldName, final T oldValue, final T newValue, boolean registerOnly) {
        PropertyChangeSupport pcs = target._propertyChangeSupport();

        if (registerOnly) {
            pcs.firePropertyChange(fieldName, oldValue, newValue, false);
            return;
        }

        if (pcs.firstSet()) {
            pcs.lazySetup();
        }

        if (!pcs.hasListeners()) {
            return;
        }

        boolean ignoreParentHandling = false;

        Class<?> targetClass = target.getClass();
        do {
            try {
                ignoreParentHandling = targetClass
                        .getDeclaredField(fieldName)
                        .isAnnotationPresent(IgnoreParentHandling.class);
                break;
            } catch (NoSuchFieldException e) {
                targetClass = targetClass.getSuperclass();
            }
        }
        while (targetClass != null);

        pcs.firePropertyChange(fieldName, oldValue, newValue, ignoreParentHandling);
    }
}
