package at.datenwort.firstClass.runtime;

/**
 * EqualityHandler, which just takes a list of other EqualityHandlers and executing them in their order until
 * an EqualityHandler returns not null.
 */
public class CompositeEqualityHandler implements EqualityHandler {
    private final EqualityHandler[] equalityHandlers;

    public CompositeEqualityHandler(EqualityHandler[] equalityHandlers) {
        this.equalityHandlers = equalityHandlers;
    }

    @Override
    public Boolean equals(Object beanA, Object beanB) {
        for (EqualityHandler handler : equalityHandlers) {
            Boolean ret = handler.equals(beanA, beanB);

            if (ret != null) {
                return ret;
            }
        }

        return null;
    }
}
