package at.datenwort.firstClass.runtime;

import java.math.BigDecimal;

/**
 * The default equality handler with special handling for BigDecimal to match if they have the
 * same value but e.g., different scales.
 */
public class DefaultEqualityHandler implements EqualityHandler {
    @Override
    public Boolean equals(Object beanA, Object beanB) {
        if (beanA instanceof BigDecimal bigDecimalA
                && beanB instanceof BigDecimal bigDecimalB) {
            return bigDecimalA.compareTo(bigDecimalB) == 0;
        }

        if (beanA != null) {
            return beanA.equals(beanB);
        }

        return beanB == null;
    }
}
