package at.datenwort.firstClass.runtime;

/**
 * <p>The equality handler is used to determine if two values are the same.</p>
 * <p>Override by configuring a service using <code>/META-INF/services/at.datenwort.firstClass.runtime.EqualityHandler</code></p>
 */
public interface EqualityHandler {
    default int getOrder() {
        return Integer.MAX_VALUE;
    }

    Boolean equals(Object beanA, Object beanB);
}
