package at.datenwort.firstClass.runtime;

import java.beans.PropertyChangeListener;
import java.lang.annotation.Annotation;

@SuppressWarnings("unused")
public interface FcProperty<T> {
    FcProperty<?> getParent();

    default Class<?> getDeclaringClass() {
        return null;
    }

    Class<T> getType();

    default T get(Object bean) {
        return get(bean, false);
    }

    default T get(Object bean, boolean direct) {
        return get(bean);
    }

    default void set(Object bean, T value) {
        set(bean, value, false);
    }

    default void set(Object bean, T value, boolean direct) {
        set(bean, value);
    }

    default boolean isWriteable(Object bean) {
        return isWriteable(bean, false);
    }

    default boolean isWriteable(Object bean, boolean direct) {
        return isWriteable(bean);
    }

    default boolean isReadable(Object bean) {
        return isReadable(bean, false);
    }

    default boolean isReadable(Object bean, boolean direct) {
        return isReadable(bean);
    }

    boolean isWriteable();

    boolean isReadable();

    default boolean isBackedByField() {
        return false;
    }

    String getName();

    String getPropertyName();

    default <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return null;
    }

    default boolean nameStartsWith(String name) {
        return getName().equals(name) || getName().startsWith(name + ".");
    }

    default void registerPropertyChangeListener(java.beans.PropertyChangeSupport propertyChangeSupport, PropertyChangeListener observableValue) {
        propertyChangeSupport.addPropertyChangeListener(getName(), observableValue);
    }
}
