package at.datenwort.firstClass.runtime;

import java.util.Collection;

public interface FirstClass<T> extends Cloneable, FcProperty<T> {
    <DUMMY> FcProperty<DUMMY> findProperty(String name);

    default <DUMMY> FirstClass<DUMMY> findFirstClass(String name) {
        FcProperty<DUMMY> property = findProperty(name);
        if (!(property instanceof FirstClass<DUMMY> ret)) {
            throw new IllegalArgumentException(name + " not a nested property");
        }

        return ret;
    }

    Collection<FcProperty<Object>> getProperties();

    Class<T> getFirstClassType();
}
