package at.datenwort.firstClass.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class FirstClassConfiguration {
    private FirstClassConfiguration() {
    }

    public final static EqualityHandler equalityHandler = createEqualityHandler();

    private static EqualityHandler createEqualityHandler() {
        ServiceLoader<EqualityHandler> equalityHandlers = ServiceLoader.load(EqualityHandler.class);

        List<EqualityHandler> equalityHandlerInstances = new ArrayList<>();

        for (EqualityHandler handler : equalityHandlers) {
            equalityHandlerInstances.add(handler);
        }

        equalityHandlerInstances.add(new DefaultEqualityHandler());

        if (equalityHandlerInstances.size() > 1) {
            equalityHandlerInstances.sort(Comparator.comparing(EqualityHandler::getOrder)
                    .thenComparing(eq -> eq.getClass().getName()));
            return new CompositeEqualityHandler(equalityHandlerInstances.toArray(new EqualityHandler[0]));
        } else {
            return equalityHandlerInstances.getFirst();
        }
    }

    public final static PropertySetter propertySetter = createPropertySetter();

    private static PropertySetter createPropertySetter() {
        // find the first property setter configured
        ServiceLoader<PropertySetter> servies = ServiceLoader.load(PropertySetter.class);
        Iterator<PropertySetter> iterServices = servies.iterator();
        if (!iterServices.hasNext()) {
            return new DefaultPropertySetter();
        }
        return iterServices.next();
    }

    public final static PropertyGetter propertyGetter = createPropertyGetter();

    private static PropertyGetter createPropertyGetter() {
        // find the first property setter configured
        ServiceLoader<PropertyGetter> servies = ServiceLoader.load(PropertyGetter.class);
        Iterator<PropertyGetter> iterServices = servies.iterator();
        if (!iterServices.hasNext()) {
            return new DefaultPropertyGetter();
        }
        return iterServices.next();
    }
}
