package at.datenwort.firstClass.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class FirstClassFactory {
    private record FirstClassInterfaceHandler(FcProperty<?> property) implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method fcMethod, Object[] args) throws Throwable {
            if (FcProperty.class.equals(fcMethod.getDeclaringClass())
                    || FirstClass.class.equals(fcMethod.getDeclaringClass())
                    || "hashCode".equals(fcMethod.getName())
                    || "equals".equals(fcMethod.getName())
                    || "toString".equals(fcMethod.getName())) {
                Object ret = fcMethod.invoke(property, args);
                return ret;
            }

            if ("getClass".equals(fcMethod.getName())) {
                return fcMethod.getDeclaringClass();
            }

            if (fcMethod.getParameterCount() == 0
                    && FcProperty.class.isAssignableFrom(fcMethod.getReturnType())) {

                //noinspection unchecked
                FcProperty<Object> fcProperty = createPropertyDefinition(property,
                        FcUtils.getFcOwnerClass(fcMethod.getDeclaringClass()),
                        fcMethod.getName(),
                        (Class<Object>) fcMethod.getReturnType()
                );

                FcProperty<?> fcPropertyProxyRet = proxy(fcMethod.getReturnType(), fcProperty);
                return fcPropertyProxyRet;
            }

            return null;
        }
    }

    static FcProperty<Object> createPropertyDefinition(FcProperty<?> parentProperty,
                                                       Class<?> declaringClass, String propertyName, Class<Object> type) {
        FcProperty<Object> fcProperty;
        FirstClass<Object> firstClass = FcUtils.getFirstClass(type);
        if (firstClass != null) {
            fcProperty = new FcFirstClassDefinition<>(
                    parentProperty,
                    declaringClass,
                    propertyName, firstClass.getFirstClassType(),
                    firstClass);
        } else {
            fcProperty = new FcPropertyDefinition<>(
                    parentProperty,
                    declaringClass,
                    propertyName);
        }
        return fcProperty;
    }

    public static <E> E proxy(final Class<?> pcClass) {
        final FcFirstClassDefinition<?> rootFirstClass = new FcFirstClassDefinition<>(
                null,
                null, null, pcClass,
                null);

        //noinspection unchecked
        return (E) Proxy.newProxyInstance(
                pcClass.getClassLoader(),
                new Class[]{pcClass},
                new FirstClassInterfaceHandler(rootFirstClass)
        );
    }

    private static <E> E proxy(Class<?> pcClass, FcProperty<?> property) {
        //noinspection unchecked
        return (E) Proxy.newProxyInstance(
                pcClass.getClassLoader(),
                new Class[]{pcClass},
                new FirstClassInterfaceHandler(property)
        );
    }
}
