package at.datenwort.firstClass.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PropertyChangeListenerEvent_PCE implements PropertyChangeListenerEvent {
    private final PropertyChangeListener listener;
    private final PropertyChangeEvent event;

    public PropertyChangeListenerEvent_PCE(PropertyChangeListener listener, PropertyChangeEvent event) {
        this.listener = listener;
        this.event = event;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    public String getPropertyName() {
        return event.getPropertyName();
    }

    public void fire() {
        listener.propertyChange(event);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PropertyChangeListenerEvent_PCE that = (PropertyChangeListenerEvent_PCE) o;

        if (!listener.equals(that.listener)) {
            return false;
        }
        return event.getPropertyName()
                .equals(that.event.getPropertyName());

    }

    @Override
    public int hashCode() {
        int result = listener.hashCode();
        result = 31 * result + event.getPropertyName()
                .hashCode();
        return result;
    }
}
