package at.datenwort.firstClass.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * <p>The property setter used to set the value for a field</p>
 * <p>Override by configuring a service using <code>/META-INF/services/at.datenwort.firstClass.runtime.PropertySetter</code></p>
 */
public interface PropertySetter {
    <T> void setField(FcProperty<T> property, Field field, Object obj, T value) throws IllegalAccessException;

    <T> void setFieldMethod(FcProperty<T> property, Method method, Object obj, T value) throws IllegalAccessException, InvocationTargetException;
}
