package at.datenwort.firstClass.runtime;

import at.datenwort.firstClass.runtime.aspect.PropertyChangeSupport;

import java.beans.PropertyChangeListener;


public interface PropertySupportInterface {
    boolean hasListeners();

    void addPropertyChangeListener(PropertyChangeListener pcl);

    void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl);

    void removePropertyChangeListener(PropertyChangeListener pcl);

    void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl);

    void firePropertyChange(String name, Object oldValue, Object newValue, boolean ignoreParentHandling);

    PropertyChangeSupport _propertyChangeSupport();

    boolean firstSet();

    void lazySetup();

    @SuppressWarnings("unused")
    static PropertySupportInterface cast(Object obj) {
        return (PropertySupportInterface) obj;
    }
}
