package at.datenwort.firstClass.runtime.aspect;

import at.datenwort.firstClass.runtime.PropertySupportInterface;

import java.beans.PropertyChangeListener;

/**
 * This is a mixin class that gets applied to all classes having the @PropertyChangeSupport annotation.
 */
public abstract class PropertyChangeSupportMixin implements PropertySupportInterface {
    private transient volatile PropertyChangeSupport _$_pcs;

    @Override
    public PropertyChangeSupport _propertyChangeSupport() {
        if (_$_pcs == null) {
            synchronized (this) {
                if (_$_pcs == null) {
                    _$_pcs = new PropertyChangeSupport(this);
                }
            }
        }
        return _$_pcs;
    }

    @Override
    public boolean hasListeners() {
        return _propertyChangeSupport().hasListeners();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        _propertyChangeSupport().addPropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        _propertyChangeSupport().addPropertyChangeListener(propertyName, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        _propertyChangeSupport().removePropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        _propertyChangeSupport().removePropertyChangeListener(propertyName, pcl);
    }

    @Override
    public void firePropertyChange(String name, Object oldValue, Object newValue, boolean ignoreParentHandling) {
        _propertyChangeSupport().firePropertyChange(name, oldValue, newValue, ignoreParentHandling);
    }

    @Override
    public boolean firstSet() {
        return _propertyChangeSupport().firstSet();
    }

    @Override
    public void lazySetup() {
        _propertyChangeSupport().lazySetup();
    }
}
