/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.blur;

import androidx.renderscript.RenderScript;
import at.favre.lib.dali.blur.IBlur;
import at.favre.lib.dali.blur.algorithms.RenderScriptGaussianBlur;
import java.util.ArrayList;
import java.util.List;

public enum EBlurAlgorithm {
    RS_GAUSS_FAST,
    RS_BOX_5x5,
    RS_GAUSS_5x5,
    RS_STACKBLUR,
    STACKBLUR,
    GAUSS_FAST,
    BOX_BLUR,
    NONE;


    public static List<EBlurAlgorithm> getAllAlgorithms() {
        ArrayList<EBlurAlgorithm> algorithms = new ArrayList<EBlurAlgorithm>();
        for (EBlurAlgorithm algorithm : EBlurAlgorithm.values()) {
            if (algorithm.equals((Object)NONE)) continue;
            algorithms.add(algorithm);
        }
        return algorithms;
    }

    public static IBlur createDefaultBlur(RenderScript rs) {
        return new RenderScriptGaussianBlur(rs);
    }
}

