/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.blur.algorithms;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import at.favre.lib.dali.blur.IBlur;

public class BoxBlur
implements IBlur {
    @Override
    public Bitmap blur(int radius, Bitmap bmp) {
        if ((radius & 1) == 0) {
            throw new IllegalArgumentException("Range must be odd.");
        }
        Bitmap blurred = Bitmap.createBitmap((int)bmp.getWidth(), (int)bmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(blurred);
        int w = bmp.getWidth();
        int h = bmp.getHeight();
        int[] pixels = new int[bmp.getWidth() * bmp.getHeight()];
        bmp.getPixels(pixels, 0, w, 0, 0, w, h);
        BoxBlur.boxBlurHorizontal(pixels, w, h, radius / 2);
        BoxBlur.boxBlurVertical(pixels, w, h, radius / 2);
        c.drawBitmap(pixels, 0, w, 0.0f, 0.0f, w, h, true, null);
        return blurred;
    }

    private static void boxBlurHorizontal(int[] pixels, int w, int h, int halfRange) {
        int index = 0;
        int[] newColors = new int[w];
        for (int y = 0; y < h; ++y) {
            int hits = 0;
            long r = 0L;
            long g = 0L;
            long b = 0L;
            for (int x = -halfRange; x < w; ++x) {
                int newPixel;
                int oldPixel = x - halfRange - 1;
                if (oldPixel >= 0) {
                    int color = pixels[index + oldPixel];
                    if (color != 0) {
                        r -= (long)Color.red((int)color);
                        g -= (long)Color.green((int)color);
                        b -= (long)Color.blue((int)color);
                    }
                    --hits;
                }
                if ((newPixel = x + halfRange) < w) {
                    int color = pixels[index + newPixel];
                    if (color != 0) {
                        r += (long)Color.red((int)color);
                        g += (long)Color.green((int)color);
                        b += (long)Color.blue((int)color);
                    }
                    ++hits;
                }
                if (x < 0) continue;
                newColors[x] = Color.argb((int)255, (int)((int)(r / (long)hits)), (int)((int)(g / (long)hits)), (int)((int)(b / (long)hits)));
            }
            System.arraycopy(newColors, 0, pixels, index + 0, w);
            index += w;
        }
    }

    private static void boxBlurVertical(int[] pixels, int w, int h, int halfRange) {
        int[] newColors = new int[h];
        int oldPixelOffset = -(halfRange + 1) * w;
        int newPixelOffset = halfRange * w;
        for (int x = 0; x < w; ++x) {
            int y;
            int hits = 0;
            long r = 0L;
            long g = 0L;
            long b = 0L;
            int index = -halfRange * w + x;
            for (y = -halfRange; y < h; ++y) {
                int newPixel;
                int oldPixel = y - halfRange - 1;
                if (oldPixel >= 0) {
                    int color = pixels[index + oldPixelOffset];
                    if (color != 0) {
                        r -= (long)Color.red((int)color);
                        g -= (long)Color.green((int)color);
                        b -= (long)Color.blue((int)color);
                    }
                    --hits;
                }
                if ((newPixel = y + halfRange) < h) {
                    int color = pixels[index + newPixelOffset];
                    if (color != 0) {
                        r += (long)Color.red((int)color);
                        g += (long)Color.green((int)color);
                        b += (long)Color.blue((int)color);
                    }
                    ++hits;
                }
                if (y >= 0) {
                    newColors[y] = Color.argb((int)255, (int)((int)(r / (long)hits)), (int)((int)(g / (long)hits)), (int)((int)(b / (long)hits)));
                }
                index += w;
            }
            for (y = 0; y < h; ++y) {
                pixels[y * w + x] = newColors[y];
            }
        }
    }
}

