/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.blur.algorithms;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicConvolve5x5;
import androidx.renderscript.Type;
import at.favre.lib.dali.blur.BlurKernels;
import at.favre.lib.dali.blur.IBlur;

public class RenderScriptBox5x5Blur
implements IBlur {
    private RenderScript rs;

    public RenderScriptBox5x5Blur(RenderScript rs) {
        this.rs = rs;
    }

    @Override
    public Bitmap blur(int radius, Bitmap bitmapOriginal) {
        Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)bitmapOriginal);
        Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
        ScriptIntrinsicConvolve5x5 script = ScriptIntrinsicConvolve5x5.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        script.setCoefficients(BlurKernels.BOX_5x5);
        for (int i = 0; i < radius; ++i) {
            script.setInput(input);
            script.forEach(output);
            input = output;
        }
        output.copyTo(bitmapOriginal);
        return bitmapOriginal;
    }
}

