/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.blur.algorithms;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import at.favre.lib.dali.ScriptC_stackblur;
import at.favre.lib.dali.blur.IBlur;

public class RenderScriptStackBlur
implements IBlur {
    private RenderScript _rs;
    private Context ctx;

    public RenderScriptStackBlur(RenderScript rs, Context ctx) {
        this.ctx = ctx;
        this._rs = rs;
    }

    @Override
    public Bitmap blur(int radius, Bitmap blurred) {
        int width = blurred.getWidth();
        int height = blurred.getHeight();
        ScriptC_stackblur blurScript = new ScriptC_stackblur(this._rs);
        Allocation inAllocation = Allocation.createFromBitmap((RenderScript)this._rs, (Bitmap)blurred);
        blurScript.set_gIn(inAllocation);
        blurScript.set_width(width);
        blurScript.set_height(height);
        blurScript.set_radius(radius);
        int[] row_indices = new int[height];
        for (int i = 0; i < height; ++i) {
            row_indices[i] = i;
        }
        Allocation rows = Allocation.createSized((RenderScript)this._rs, (Element)Element.U32((RenderScript)this._rs), (int)height, (int)1);
        rows.copyFrom(row_indices);
        row_indices = new int[width];
        for (int i = 0; i < width; ++i) {
            row_indices[i] = i;
        }
        Allocation columns = Allocation.createSized((RenderScript)this._rs, (Element)Element.U32((RenderScript)this._rs), (int)width, (int)1);
        columns.copyFrom(row_indices);
        blurScript.forEach_blur_h(rows);
        blurScript.forEach_blur_v(columns);
        inAllocation.copyTo(blurred);
        return blurred;
    }
}

