/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder;

import at.favre.lib.dali.Dali;
import at.favre.lib.dali.builder.blur.BlurWorker;
import at.favre.lib.dali.util.BuilderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorManager {
    private static final int MAX_QUEUE = 25;
    private ThreadPoolExecutor serialThreadPool;
    private ThreadPoolExecutor concurrentThreadPool;
    private ThreadPoolExecutor fireAndForgetThreadPool;
    private Map<String, List<Future<BlurWorker.Result>>> taskList;

    public ExecutorManager(int maxConcurrentMainWorkers) {
        this.concurrentThreadPool = new ThreadPoolExecutor(maxConcurrentMainWorkers, maxConcurrentMainWorkers, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(25));
        this.concurrentThreadPool.allowCoreThreadTimeOut(true);
        this.serialThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(25));
        this.fireAndForgetThreadPool = new ThreadPoolExecutor(4, 4, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(25));
        this.fireAndForgetThreadPool.allowCoreThreadTimeOut(true);
        this.taskList = new ConcurrentHashMap<String, List<Future<BlurWorker.Result>>>();
    }

    public Future<BlurWorker.Result> submitThreadPool(Callable<BlurWorker.Result> callable, String tag, ThreadPoolType type) {
        Future<BlurWorker.Result> future = null;
        future = type.equals((Object)ThreadPoolType.CONCURRENT) ? this.concurrentThreadPool.submit(callable) : this.serialThreadPool.submit(callable);
        if (!this.taskList.containsKey(tag)) {
            this.taskList.put(tag, new ArrayList());
        }
        this.taskList.get(tag).add(future);
        this.removeDoneTasks();
        return future;
    }

    public synchronized int cancelByTag(String tagToCancel) {
        int i = 0;
        if (this.taskList.containsKey(tagToCancel)) {
            this.removeDoneTasks();
            for (Future<BlurWorker.Result> future : this.taskList.get(tagToCancel)) {
                BuilderUtil.logVerbose(Dali.getConfig().logTag, "Canceling task with tag " + tagToCancel, Dali.getConfig().debugMode);
                future.cancel(true);
                ++i;
            }
            Iterator<Future<BlurWorker.Result>> iter = this.taskList.get(tagToCancel).iterator();
            while (iter.hasNext()) {
                if (!iter.next().isCancelled()) continue;
                iter.remove();
            }
        }
        return i;
    }

    private void removeDoneTasks() {
        for (String tag : this.taskList.keySet()) {
            Iterator<Future<BlurWorker.Result>> iter = this.taskList.get(tag).iterator();
            while (iter.hasNext()) {
                if (!iter.next().isDone()) continue;
                iter.remove();
            }
            if (!this.taskList.get(tag).isEmpty()) continue;
            this.taskList.remove(tag);
        }
    }

    public void executeOnFireAndForgetThreadPool(Runnable r) {
        this.fireAndForgetThreadPool.execute(r);
    }

    public void shutDown() {
        this.concurrentThreadPool.shutdown();
        this.serialThreadPool.shutdown();
        this.fireAndForgetThreadPool.shutdown();
    }

    public static enum ThreadPoolType {
        SERIAL,
        CONCURRENT;

    }
}

