/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.view.View;
import at.favre.lib.dali.util.BuilderUtil;
import at.favre.lib.dali.util.LegacySDKUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ImageReference {
    private static final String CACHE_KEY_PREFIX = "cachekey_";
    private Integer resId;
    private InputStream inputStream;
    private Bitmap bitmap;
    private File fileToBitmap;
    private View view;
    private String contentId;
    private SourceType type = SourceType.UNKNOWN;
    private BitmapFactory.Options decoderOptions;

    public ImageReference(int resId) {
        this.resId = resId;
        this.contentId = "resid_" + resId;
        this.type = SourceType.RES_ID;
    }

    public ImageReference(InputStream inputStream) {
        this(inputStream, String.valueOf(inputStream.hashCode()));
    }

    public ImageReference(InputStream inputStream, String cacheKey) {
        this.inputStream = inputStream;
        this.contentId = CACHE_KEY_PREFIX + cacheKey;
        this.type = SourceType.INPUT_STREAM;
    }

    public ImageReference(Bitmap bitmap) {
        this(bitmap, LegacySDKUtil.getBitmapId(bitmap));
    }

    public ImageReference(Bitmap bitmap, String cacheKey) {
        this.bitmap = bitmap;
        this.contentId = CACHE_KEY_PREFIX + cacheKey;
        this.type = SourceType.BITMAP;
    }

    public ImageReference(File fileToBitmap) {
        this(fileToBitmap, "file_" + fileToBitmap.getAbsolutePath());
    }

    public ImageReference(File fileToBitmap, String cacheKey) {
        this.fileToBitmap = fileToBitmap;
        this.contentId = cacheKey;
        this.type = SourceType.FILE;
    }

    public ImageReference(View view) {
        this.view = view;
        this.contentId = "view_" + view.hashCode();
        this.type = SourceType.VIEW;
    }

    public void setDecoderOptions(BitmapFactory.Options decoderOptions) {
        this.decoderOptions = decoderOptions;
    }

    public BitmapFactory.Options getDecoderOptions() {
        return this.decoderOptions;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public Bitmap synchronouslyLoadBitmap(Resources resources) {
        if (this.bitmap != null) {
            if (this.decoderOptions != null && this.decoderOptions.inSampleSize > 1) {
                return Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)(this.bitmap.getWidth() / this.decoderOptions.inSampleSize), (int)(this.bitmap.getHeight() / this.decoderOptions.inSampleSize), (boolean)false);
            }
            return this.bitmap;
        }
        if (this.resId != null) {
            return BitmapFactory.decodeResource((Resources)resources, (int)this.resId, (BitmapFactory.Options)this.decoderOptions);
        }
        if (this.fileToBitmap != null) {
            return BitmapFactory.decodeFile((String)this.fileToBitmap.getAbsolutePath(), (BitmapFactory.Options)this.decoderOptions);
        }
        if (this.inputStream != null) {
            return BitmapFactory.decodeStream((InputStream)this.inputStream, null, (BitmapFactory.Options)this.decoderOptions);
        }
        if (this.view != null) {
            int downSample = 1;
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            if (this.decoderOptions != null) {
                if (this.decoderOptions.inSampleSize > 1) {
                    downSample = this.decoderOptions.inSampleSize;
                }
                if (this.decoderOptions.inPreferredConfig != null) {
                    config = this.decoderOptions.inPreferredConfig;
                }
            }
            return BuilderUtil.drawViewToBitmap(this.bitmap, this.view, downSample, config);
        }
        throw new IllegalStateException("No image resource was set");
    }

    public Point measureImage(Resources resources) {
        BitmapFactory.Options justBoundsOptions = new BitmapFactory.Options();
        justBoundsOptions.inJustDecodeBounds = true;
        if (this.bitmap != null) {
            return new Point(this.bitmap.getWidth(), this.bitmap.getHeight());
        }
        if (this.resId != null) {
            BitmapFactory.decodeResource((Resources)resources, (int)this.resId, (BitmapFactory.Options)justBoundsOptions);
            float scale = (float)justBoundsOptions.inTargetDensity / (float)justBoundsOptions.inDensity;
            return new Point((int)((float)justBoundsOptions.outWidth * scale + 0.5f), (int)((float)justBoundsOptions.outHeight * scale + 0.5f));
        }
        if (this.fileToBitmap != null) {
            BitmapFactory.decodeFile((String)this.fileToBitmap.getAbsolutePath(), (BitmapFactory.Options)justBoundsOptions);
        } else if (this.inputStream != null) {
            BitmapFactory.decodeStream((InputStream)this.inputStream, null, (BitmapFactory.Options)justBoundsOptions);
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {}
        } else if (this.view != null) {
            return new Point(this.view.getWidth(), this.view.getHeight());
        }
        return new Point(justBoundsOptions.outWidth, justBoundsOptions.outHeight);
    }

    public SourceType getSourceType() {
        return this.type;
    }

    public Integer getResId() {
        return this.resId;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public File getFileToBitmap() {
        return this.fileToBitmap;
    }

    public View getView() {
        return this.view;
    }

    public static enum SourceType {
        RES_ID,
        INPUT_STREAM,
        BITMAP,
        FILE,
        VIEW,
        UNKNOWN;

    }
}

