/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder;

import android.util.Log;
import at.favre.lib.dali.util.BenchmarkUtil;
import java.util.ArrayList;
import java.util.List;

public class PerformanceProfiler {
    private static final String TAG = PerformanceProfiler.class.getSimpleName();
    private String description;
    private List<Duration> durations;
    private boolean isActivated;

    public PerformanceProfiler(String description) {
        this(description, true);
    }

    public PerformanceProfiler(String description, boolean isActivated) {
        this.description = description;
        this.durations = new ArrayList<Duration>();
        this.isActivated = isActivated;
    }

    public void startTask(int id, String taskName) {
        if (this.isActivated) {
            this.durations.add(new Duration(id, taskName, BenchmarkUtil.elapsedRealTimeNanos()));
        }
    }

    public void endTask(int id) {
        this.endTask(id, null);
    }

    public void endTask(int id, String additionalInfo) {
        if (this.isActivated) {
            for (Duration duration : this.durations) {
                if (duration.getId() != id) continue;
                duration.setEndTimstamp(BenchmarkUtil.elapsedRealTimeNanos());
                if (additionalInfo != null) {
                    duration.setAdditionalInfo(additionalInfo);
                }
                return;
            }
            Log.w((String)TAG, (String)("Could not find task with id " + id));
        }
    }

    public double getDurationMs() {
        double durationMs = 0.0;
        for (Duration duration : this.durations) {
            if (!duration.taskFinished()) continue;
            durationMs += duration.getDurationMS();
        }
        return durationMs;
    }

    public void printResultToLog(String tag) {
        if (this.isActivated) {
            StringBuilder sb = new StringBuilder("->\nLog profile for task " + this.description + " - " + BenchmarkUtil.formatNum(this.getDurationMs(), "0.##") + "ms\n----------------------------------------\n");
            for (Duration duration : this.durations) {
                String logMsg = " * " + duration.getTaskDescription();
                if (duration.getAdditionalInfo() != null && !duration.getAdditionalInfo().isEmpty()) {
                    logMsg = logMsg + " / " + duration.getAdditionalInfo();
                }
                logMsg = duration.taskFinished() ? logMsg + " - " + BenchmarkUtil.formatNum(duration.getDurationMS(), "0.##") + "ms" : logMsg + " - unfinished";
                sb.append(logMsg + "\n");
            }
            Log.d((String)tag, (String)sb.toString());
        }
    }

    public void printResultToLog() {
        this.printResultToLog(TAG);
    }

    public static class Duration {
        private int id;
        private String taskDescription;
        private String additionalInfo;
        private long startTimestamp;
        private long duration = -1L;

        public Duration(int id, String taskDescription, long startTimestamp) {
            this.id = id;
            this.taskDescription = taskDescription;
            this.startTimestamp = startTimestamp;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public void setEndTimstamp(long endTimstamp) {
            this.duration = endTimstamp - this.startTimestamp;
        }

        public long getDuration() {
            return this.duration;
        }

        public double getDurationMS() {
            return (double)this.duration / 1000000.0;
        }

        public boolean taskFinished() {
            return this.duration != -1L;
        }

        public String getTaskDescription() {
            return this.taskDescription;
        }

        public int getId() {
            return this.id;
        }
    }
}

