/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.collection.LruCache;
import at.favre.lib.dali.util.BenchmarkUtil;
import at.favre.lib.dali.util.BuilderUtil;
import at.favre.lib.dali.util.LegacySDKUtil;
import at.favre.lib.dali.util.Precondition;
import com.jakewharton.disklrucache.DiskLruCache;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TwoLevelCache {
    private static final String TAG = TwoLevelCache.class.getSimpleName();
    private static final int DISK_CACHE_SIZE_BYTE = 0xA00000;
    private static final int MEMORY_CACHE_SIZE_FACTOR = 10;
    private static final String DISK_CACHE_FOLDER_NAME = "dali_diskcache";
    private static final int IO_BUFFER_SIZE_BYTE = 8192;
    private static final Bitmap.CompressFormat FORMAT = Bitmap.CompressFormat.PNG;
    private DiskLruCache diskLruCache;
    private BitmapLruMemoryCache memoryCache;
    private Context ctx;
    private boolean useMemoryCache;
    private boolean useDiskCache;
    private boolean debugMode;
    private int diskCacheSizeByte;
    private String diskCacheFolderName;
    private int memoryCacheSizeByte;

    public TwoLevelCache(Context ctx) {
        this.ctx = ctx.getApplicationContext();
        this.useMemoryCache = true;
        this.useDiskCache = true;
        this.debugMode = false;
        this.diskCacheSizeByte = 0xA00000;
        this.diskCacheFolderName = DISK_CACHE_FOLDER_NAME;
        this.memoryCacheSizeByte = (int)Runtime.getRuntime().maxMemory() / 10;
    }

    public TwoLevelCache(Context ctx, boolean useMemoryCache, boolean useDiskCache, int diskCacheSizeByte, String diskCacheFolderName, int memoryCacheSizeByte, boolean debugMode) {
        this.ctx = ctx;
        this.useMemoryCache = useMemoryCache;
        this.useDiskCache = useDiskCache;
        this.debugMode = debugMode;
        this.diskCacheSizeByte = diskCacheSizeByte;
        this.diskCacheFolderName = diskCacheFolderName;
        this.memoryCacheSizeByte = memoryCacheSizeByte;
    }

    public DiskLruCache getDiskCache() {
        if (this.diskLruCache == null) {
            try {
                this.diskLruCache = DiskLruCache.open((File)new File(LegacySDKUtil.getCacheDir(this.ctx), this.diskCacheFolderName), (int)60, (int)1, (long)this.diskCacheSizeByte);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Could not create disk cache", (Throwable)e);
            }
        }
        return this.diskLruCache;
    }

    public BitmapLruMemoryCache getMemoryCache() {
        if (this.memoryCache == null) {
            this.memoryCache = new BitmapLruMemoryCache(this.memoryCacheSizeByte, this.debugMode);
        }
        return this.memoryCache;
    }

    public Bitmap get(String cacheKey) {
        Bitmap cache = null;
        if (this.useMemoryCache && (cache = this.getFromMemoryCache(cacheKey)) != null) {
            BuilderUtil.logVerbose(TAG, "found in memory cache (key: " + cacheKey + ")", this.debugMode);
            return cache;
        }
        if (this.useDiskCache && (cache = this.getFromDiskCache(cacheKey)) != null) {
            if (this.useMemoryCache) {
                this.putBitmapToMemoryCache(cache, cacheKey);
            }
            BuilderUtil.logVerbose(TAG, "found in disk cache (key: " + cacheKey + ")", this.debugMode);
        }
        return cache;
    }

    public boolean putInCache(Bitmap bitmap, String cacheKey) {
        boolean memoryResult = false;
        boolean diskresult = false;
        if (this.useMemoryCache) {
            memoryResult = this.putBitmapToMemoryCache(bitmap, cacheKey);
        }
        if (this.useDiskCache) {
            diskresult = this.putBitmapToDiskCache(bitmap, cacheKey);
        }
        BuilderUtil.logVerbose(TAG, "could put in memoryCache: " + memoryResult + ", could put in disk cache: " + diskresult + " (key: " + cacheKey + ")", this.debugMode);
        return !(!memoryResult && this.useMemoryCache || !diskresult && this.useDiskCache);
    }

    public Bitmap getFromMemoryCache(String cacheKey) {
        Precondition.checkArgument("memory cache disabled", this.useMemoryCache);
        if (this.getMemoryCache() != null) {
            return (Bitmap)this.getMemoryCache().get(cacheKey);
        }
        return null;
    }

    public boolean putBitmapToMemoryCache(Bitmap bitmap, String cacheKey) {
        Precondition.checkArgument("memory cache disabled", this.useMemoryCache);
        if (this.getMemoryCache() != null) {
            try {
                this.getMemoryCache().put(cacheKey, bitmap);
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Could not put to memory cache", (Throwable)t);
            }
        }
        return false;
    }

    public Bitmap getFromDiskCache(String cacheKey) {
        Precondition.checkArgument("disk cache disabled", this.useDiskCache);
        if (this.getDiskCache() != null) {
            try {
                DiskLruCache.Snapshot snapshot = this.getDiskCache().get(cacheKey);
                if (snapshot != null) {
                    return BitmapFactory.decodeStream((InputStream)snapshot.getInputStream(0));
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Could not read from disk cache", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBitmapToDiskCache(Bitmap bitmap, String cacheKey) {
        Precondition.checkArgument("disk cache disabled", this.useDiskCache);
        if (this.getDiskCache() != null) {
            OutputStream out = null;
            try {
                DiskLruCache.Editor editor = this.getDiskCache().edit(cacheKey);
                if (editor != null) {
                    out = new BufferedOutputStream(editor.newOutputStream(0), 8192);
                    if (bitmap.compress(FORMAT, 100, out)) {
                        editor.commit();
                        boolean bl = true;
                        return bl;
                    }
                    Log.w((String)TAG, (String)"Could not compress png for disk cache");
                    editor.abort();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Could not write outputstream for disk cache", (Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Log.w((String)TAG, (String)"Could not close outputstream while writing cache", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    public synchronized void clear() {
        this.clearMemoryCache();
        this.clearDiskCache();
    }

    public synchronized void clearMemoryCache() {
        if (this.memoryCache != null) {
            this.memoryCache.evictAll();
            this.memoryCache = null;
        }
    }

    public synchronized void clearDiskCache() {
        if (this.diskLruCache != null) {
            try {
                this.diskLruCache.delete();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Could not clear diskcache", (Throwable)e);
            }
            this.diskLruCache = null;
        }
    }

    public void purge(String cacheKey) {
        try {
            if (this.useMemoryCache && this.memoryCache != null) {
                this.memoryCache.remove(cacheKey);
            }
            if (this.useDiskCache && this.diskLruCache != null) {
                this.diskLruCache.remove(cacheKey);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not remove entry in cache purge", (Throwable)e);
        }
    }

    private static class BitmapLruMemoryCache
    extends LruCache<String, Bitmap> {
        public BitmapLruMemoryCache(int maxSizeInBytes, boolean debugMode) {
            super(maxSizeInBytes);
            BuilderUtil.logDebug(TAG, "Create memory cache with " + BenchmarkUtil.getScalingUnitByteSize(maxSizeInBytes), debugMode);
        }

        protected int sizeOf(String key, Bitmap bitmap) {
            return LegacySDKUtil.byteSizeOf(bitmap);
        }
    }
}

