/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.animation;

import android.animation.TimeInterpolator;
import android.view.animation.LinearInterpolator;
import at.favre.lib.dali.builder.animation.BlurKeyFrameManager;
import at.favre.lib.dali.util.BuilderUtil;

public class BlurKeyFrameAnimationBuilder {
    private int startDownSample = 2;
    private int endDownSample = 8;
    private int framesCount = 4;
    private int endBlurRadius = 16;
    private float endBrightness = 0.0f;
    private long durationOfWholeAnimationMs = 800L;
    private TimeInterpolator interpolator = new LinearInterpolator();

    public BlurKeyFrameAnimationBuilder keyFrames(int framesCount) {
        this.framesCount = framesCount;
        return this;
    }

    public BlurKeyFrameAnimationBuilder startDownSample(int startDownSample) {
        this.startDownSample = startDownSample;
        return this;
    }

    public BlurKeyFrameAnimationBuilder endDownSample(int endDownSample) {
        this.endDownSample = endDownSample;
        return this;
    }

    public BlurKeyFrameAnimationBuilder blurRadius(int blurRadius) {
        BuilderUtil.checkBlurRadiusPrecondition(blurRadius);
        this.endBlurRadius = blurRadius;
        return this;
    }

    public BlurKeyFrameAnimationBuilder brightness(int brightness) {
        this.endBrightness = brightness;
        return this;
    }

    public BlurKeyFrameAnimationBuilder duration(long milliseconds) {
        this.durationOfWholeAnimationMs = milliseconds;
        return this;
    }

    public BlurKeyFrameAnimationBuilder interpolator(TimeInterpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    public BlurKeyFrameManager build() {
        BlurKeyFrameManager man = new BlurKeyFrameManager();
        return man;
    }
}

