/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.animation;

import android.content.Context;
import android.graphics.Bitmap;
import at.favre.lib.dali.Dali;
import at.favre.lib.dali.builder.animation.BlurKeyFrame;
import java.util.ArrayList;
import java.util.List;

public class BlurKeyFrameManager {
    private List<BlurKeyFrame> keyFrames = new ArrayList<BlurKeyFrame>();

    public static BlurKeyFrameManager createLinearKeyFrames(int keyFrames, int duration, int inSampleSize, int endBlurRadius, int endBrightness) {
        BlurKeyFrameManager man = new BlurKeyFrameManager();
        int durationPerFrame = (int)((float)duration / (float)keyFrames);
        int radiusIncrement = (int)((float)endBlurRadius / (float)keyFrames);
        int brightnessIncrement = 0;
        if (endBrightness != 0) {
            brightnessIncrement = (int)((float)endBrightness / (float)keyFrames);
        }
        for (int i = 0; i < keyFrames; ++i) {
            man.addKeyFrame(new BlurKeyFrame(inSampleSize, radiusIncrement * (i + 1), brightnessIncrement * (i + 1), durationPerFrame));
        }
        return man;
    }

    public static BlurKeyFrameManager createLowMemoryKeyframes(int keyFrames, int duration, int startInsampleSize, int endBlurRadius) {
        BlurKeyFrameManager man = new BlurKeyFrameManager();
        int durationPerFrame = (int)((float)duration / (float)keyFrames);
        int radiusIncrement = (int)((float)endBlurRadius / (float)keyFrames);
        for (int i = 0; i < keyFrames; ++i) {
            man.addKeyFrame(new BlurKeyFrame(startInsampleSize, radiusIncrement * (i + 1), 0.0f, durationPerFrame));
        }
        return man;
    }

    public void addKeyFrame(BlurKeyFrame frame) {
        this.keyFrames.add(frame);
    }

    protected KeyFrameData prepareFrames(Context ctx, Bitmap original) {
        return new KeyFrameData(ctx, original, this.keyFrames);
    }

    public List<BlurKeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public String toString() {
        return this.keyFrames.toString();
    }

    public static class KeyFrameData {
        private Bitmap original;
        private List<Bitmap> frames = new ArrayList<Bitmap>();
        private List<BlurKeyFrame> keyFrameConfigList;

        public KeyFrameData(Context ctx, Bitmap original, List<BlurKeyFrame> keyFrames) {
            this.original = original;
            this.keyFrameConfigList = keyFrames;
            Dali dali = Dali.create(ctx);
            this.frames.add(original);
            for (BlurKeyFrame keyFrame : keyFrames) {
                this.frames.add(keyFrame.prepareFrame(original, dali));
            }
        }

        public List<BlurKeyFrame> getKeyFrameConfigList() {
            return this.keyFrameConfigList;
        }

        public List<Bitmap> getFrames() {
            return this.frames;
        }

        public Bitmap getOriginal() {
            return this.original;
        }
    }
}

