/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.animation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import at.favre.lib.dali.builder.animation.BlurKeyFrameManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BlurKeyFrameTransitionAnimation {
    private static final String TAG = BlurKeyFrameTransitionAnimation.class.getSimpleName();
    private List<TransitionDrawable> transitionDrawables = new ArrayList<TransitionDrawable>();
    private Context ctx;
    private Handler handler = new Handler(Looper.getMainLooper());
    private BlurKeyFrameManager manager;
    private List<Runnable> runnables;
    private boolean running = false;
    private boolean canceled = false;
    private KeyFrameAnimationListener listener;

    public BlurKeyFrameTransitionAnimation(Context ctx, BlurKeyFrameManager manager) {
        this.ctx = ctx;
        this.manager = manager;
        this.runnables = new CopyOnWriteArrayList<Runnable>();
    }

    public void prepareAnimation(Bitmap original) {
        BlurKeyFrameManager.KeyFrameData data = this.manager.prepareFrames(this.ctx, original);
        this.transitionDrawables = new ArrayList<TransitionDrawable>();
        for (int i = 0; i < data.getFrames().size(); ++i) {
            if (i + 1 >= data.getFrames().size()) continue;
            TransitionDrawable t = new TransitionDrawable(new Drawable[]{new BitmapDrawable(this.ctx.getResources(), data.getFrames().get(i)), new BitmapDrawable(this.ctx.getResources(), data.getFrames().get(i + 1))});
            this.transitionDrawables.add(t);
        }
    }

    public void start(final ImageView imageView) {
        if (this.listener != null) {
            this.listener.onAnimationStart();
        }
        long duration = 0L;
        for (int i = 0; i < this.transitionDrawables.size(); ++i) {
            final int iterator = i;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TransitionDrawable t = (TransitionDrawable)BlurKeyFrameTransitionAnimation.this.transitionDrawables.get(iterator);
                    t.startTransition(BlurKeyFrameTransitionAnimation.this.manager.getKeyFrames().get(iterator).getDuration());
                    imageView.setImageDrawable((Drawable)t);
                    Log.d((String)TAG, (String)("transition " + iterator));
                }
            }, duration);
            duration += (long)this.manager.getKeyFrames().get(i).getDuration();
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"reset animation");
                for (TransitionDrawable transitionDrawable : BlurKeyFrameTransitionAnimation.this.transitionDrawables) {
                    transitionDrawable.resetTransition();
                }
                if (BlurKeyFrameTransitionAnimation.this.listener != null) {
                    BlurKeyFrameTransitionAnimation.this.listener.onAnimationEnd();
                }
            }
        }, duration);
    }

    public synchronized void cancel() {
        this.canceled = true;
        this.running = false;
    }

    public static interface KeyFrameAnimationListener {
        public void onAnimationStart();

        public void onKeyFrameChange(int var1);

        public void onAnimationEnd();
    }
}

