/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.blur;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import at.favre.lib.dali.Dali;
import at.favre.lib.dali.R;
import at.favre.lib.dali.blur.EBlurAlgorithm;
import at.favre.lib.dali.blur.IBlur;
import at.favre.lib.dali.blur.algorithms.RenderScriptGaussianBlur;
import at.favre.lib.dali.builder.ABuilder;
import at.favre.lib.dali.builder.ContextWrapper;
import at.favre.lib.dali.builder.ExecutorManager;
import at.favre.lib.dali.builder.ImageReference;
import at.favre.lib.dali.builder.TwoLevelCache;
import at.favre.lib.dali.builder.blur.BlurWorker;
import at.favre.lib.dali.builder.exception.BlurWorkerException;
import at.favre.lib.dali.builder.processor.ColorFilterProcessor;
import at.favre.lib.dali.builder.processor.ContrastProcessor;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;
import at.favre.lib.dali.builder.processor.RenderscriptBrightnessProcessor;
import at.favre.lib.dali.util.BuilderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;

public class BlurBuilder
extends ABuilder {
    private static final String TAG = BlurBuilder.class.getSimpleName();
    private static final int FADE_IN_MS = 200;
    private BlurData data;
    private Handler uiThreadHandler = new Handler(Looper.getMainLooper());

    @TargetApi(value=11)
    public BlurBuilder(ContextWrapper contextWrapper, ImageReference imageReference, TwoLevelCache diskCacheManager) {
        this.data = new BlurData();
        this.data.imageReference = imageReference;
        this.data.contextWrapper = contextWrapper;
        this.data.blurAlgorithm = new RenderScriptGaussianBlur(this.data.contextWrapper.getRenderScript());
        this.data.diskCacheManager = diskCacheManager;
        this.data.options.inMutable = true;
    }

    public BlurBuilder blurRadius(int blurRadius) {
        BuilderUtil.checkBlurRadiusPrecondition(blurRadius);
        this.data.blurRadius = blurRadius;
        return this;
    }

    public BlurBuilder copyBitmapBeforeProcess() {
        this.data.copyBitmapBeforeBlur = true;
        return this;
    }

    public BlurBuilder downScale(int scaleInSample) {
        this.data.options.inSampleSize = Math.min(Math.max(1, scaleInSample), 16384);
        return this;
    }

    public BlurBuilder reScale() {
        this.data.rescaleIfDownscaled = true;
        return this;
    }

    public BlurBuilder options(BitmapFactory.Options options) {
        if (options != null) {
            this.data.options = options;
        }
        return this;
    }

    public BlurBuilder addPreProcessor(IBitmapProcessor processor) {
        this.data.preProcessors.add(processor);
        return this;
    }

    public BlurBuilder brightness(float brightness) {
        this.data.preProcessors.add(new RenderscriptBrightnessProcessor(this.data.contextWrapper.getRenderScript(), brightness, this.data.contextWrapper.getResources()));
        return this;
    }

    public BlurBuilder contrast(float contrast) {
        this.data.preProcessors.add(new ContrastProcessor(this.data.contextWrapper.getRenderScript(), Math.max(Math.min(1500.0f, contrast), -1500.0f)));
        return this;
    }

    public BlurBuilder colorFilter(int colorResId) {
        this.data.preProcessors.add(new ColorFilterProcessor(colorResId, PorterDuff.Mode.MULTIPLY));
        return this;
    }

    public BlurBuilder addPostProcessor(IBitmapProcessor processor) {
        this.data.postProcessors.add(processor);
        return this;
    }

    public BlurBuilder algorithm(EBlurAlgorithm algorithm) {
        this.data.blurAlgorithm = BuilderUtil.getIBlurAlgorithm(algorithm, this.data.contextWrapper);
        return this;
    }

    public BlurBuilder algorithm(IBlur blurAlgorithm) {
        this.data.blurAlgorithm = blurAlgorithm;
        return this;
    }

    public BlurBuilder skipCache() {
        this.data.shouldCache = false;
        return this;
    }

    public BlurBuilder tag(String tag) {
        this.data.tag = tag;
        return this;
    }

    public BlurBuilder error(int resId) {
        this.data.errorResId = resId;
        return this;
    }

    public BlurBuilder noFade() {
        this.data.alphaFadeIn = false;
        return this;
    }

    public BlurBuilder concurrent() {
        this.data.onConcurrentThreadPool = true;
        return this;
    }

    public BlurBuilder placeholder(int resId) {
        this.data.placeholder = resId;
        return this;
    }

    public JobDescription into(final ImageView imageView) {
        if (this.data.placeholder != -1) {
            imageView.setImageResource(this.data.placeholder);
        }
        return this.start(new BlurWorker.BlurWorkerListener(){

            @Override
            public void onResult(final BlurWorker.Result result) {
                BlurBuilder.this.uiThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (result.isError()) {
                            Log.e((String)TAG, (String)"Could not set into imageview", (Throwable)result.getThrowable());
                            if (((BlurBuilder)BlurBuilder.this).data.errorResId == -1) {
                                imageView.setImageResource(((BlurBuilder)BlurBuilder.this).data.errorResId);
                            }
                        } else if (((BlurBuilder)BlurBuilder.this).data.alphaFadeIn) {
                            ColorDrawable placeholder;
                            Drawable oldDrawable = imageView.getDrawable();
                            if (oldDrawable != null) {
                                if (oldDrawable instanceof LayerDrawable) {
                                    LayerDrawable oldLayerDrawable = (LayerDrawable)oldDrawable;
                                    placeholder = oldLayerDrawable.getDrawable(0);
                                } else {
                                    placeholder = imageView.getDrawable();
                                }
                            } else {
                                placeholder = new ColorDrawable(Color.parseColor((String)"#00FFFFFF"));
                            }
                            TransitionDrawable transition = new TransitionDrawable(new Drawable[]{placeholder, new BitmapDrawable(((BlurBuilder)BlurBuilder.this).data.contextWrapper.getResources(), result.getBitmap())});
                            imageView.setImageDrawable((Drawable)transition);
                            transition.startTransition(200);
                        } else {
                            imageView.setImageDrawable((Drawable)new BitmapDrawable(((BlurBuilder)BlurBuilder.this).data.contextWrapper.getResources(), result.getBitmap()));
                        }
                    }
                });
            }
        });
    }

    public JobDescription start(BlurWorker.BlurWorkerListener listener) {
        Dali.getExecutorManager().submitThreadPool(new BlurWorker(this.data, listener), this.data.tag, this.data.onConcurrentThreadPool ? ExecutorManager.ThreadPoolType.CONCURRENT : ExecutorManager.ThreadPoolType.SERIAL);
        return this.getJobDescription();
    }

    public BitmapDrawable get() {
        return new BitmapDrawable(this.data.contextWrapper.getResources(), this.getAsBitmap());
    }

    public Bitmap getAsBitmap() {
        Future<BlurWorker.Result> result = Dali.getExecutorManager().submitThreadPool(new BlurWorker(this.data), this.data.tag, this.data.onConcurrentThreadPool ? ExecutorManager.ThreadPoolType.CONCURRENT : ExecutorManager.ThreadPoolType.SERIAL);
        BlurWorker.Result r = null;
        try {
            r = result.get();
        }
        catch (Exception e) {
            throw new BlurWorkerException("Could not get bitmap from future", e);
        }
        if (r != null) {
            if (r.isError()) {
                throw new BlurWorkerException(r.getThrowable());
            }
            return r.getBitmap();
        }
        throw new BlurWorkerException("result was null");
    }

    public JobDescription getJobDescription() {
        return new JobDescription(BuilderUtil.getCacheKey(this.data), BuilderUtil.getBuilderDescription(this.data), this.data.tag);
    }

    public static interface TaskFinishedListener {
        public void onBitmapReady(Bitmap var1);

        public void onError(Throwable var1);
    }

    public static class JobDescription {
        public final String cacheKey;
        public final String builderDescription;
        public final String tag;

        public JobDescription(String cacheKey, String builderDescription, String tag) {
            this.cacheKey = cacheKey;
            this.builderDescription = builderDescription;
            this.tag = tag;
        }
    }

    public static class BlurData
    extends ABuilder.Data {
        public BitmapFactory.Options options = new BitmapFactory.Options();
        public boolean copyBitmapBeforeBlur = false;
        public boolean rescaleIfDownscaled = false;
        public boolean shouldCache = true;
        public ImageReference imageReference;
        public ContextWrapper contextWrapper;
        public List<IBitmapProcessor> preProcessors = new ArrayList<IBitmapProcessor>();
        public List<IBitmapProcessor> postProcessors = new ArrayList<IBitmapProcessor>();
        public TwoLevelCache diskCacheManager;
        public String tag = UUID.randomUUID().toString();
        public int errorResId = R.drawable.ic_error_pic;
        public boolean alphaFadeIn = true;
        public boolean onConcurrentThreadPool = false;
        public int placeholder = -1;
    }
}

