/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.blur;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import at.favre.lib.dali.Dali;
import at.favre.lib.dali.builder.ImageReference;
import at.favre.lib.dali.builder.PerformanceProfiler;
import at.favre.lib.dali.builder.blur.BlurBuilder;
import at.favre.lib.dali.builder.exception.BlurWorkerException;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;
import at.favre.lib.dali.util.BenchmarkUtil;
import at.favre.lib.dali.util.BuilderUtil;
import at.favre.lib.dali.util.LegacySDKUtil;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BlurWorker
implements Callable<Result> {
    private static final String TAG = BlurWorker.class.getSimpleName();
    private final String id = UUID.randomUUID().toString();
    private BlurWorkerListener listener;
    private BlurBuilder.BlurData builderData;
    private final Semaphore semaphore = new Semaphore(0, true);
    private Handler uiThreadHandler = new Handler(Looper.getMainLooper());

    public BlurWorker(BlurBuilder.BlurData builderData) {
        this(builderData, null);
    }

    public BlurWorker(BlurBuilder.BlurData builderData, BlurWorkerListener listener) {
        this.builderData = builderData;
        this.listener = listener;
    }

    @Override
    public Result call() {
        try {
            Result r = new Result(this.process());
            if (this.listener != null) {
                this.listener.onResult(r);
            }
            return r;
        }
        catch (Throwable t) {
            Result r = new Result(t);
            if (this.listener != null) {
                this.listener.onResult(r);
            }
            return r;
        }
    }

    private Bitmap process() {
        PerformanceProfiler profiler = new PerformanceProfiler("blur image task [" + this.builderData.tag + "] started at " + BenchmarkUtil.getCurrentTime(), Dali.getConfig().debugMode);
        try {
            String cacheKey = BuilderUtil.getCacheKey(this.builderData);
            if (this.builderData.shouldCache) {
                profiler.startTask(-3, "cache lookup (key:" + cacheKey + ")");
                Bitmap cache = this.builderData.diskCacheManager.get(cacheKey);
                profiler.endTask(-3, cache == null ? "miss" : "hit");
                if (cache != null) {
                    profiler.printResultToLog();
                    Bitmap bitmap = cache;
                    return bitmap;
                }
            } else {
                this.builderData.diskCacheManager.purge(cacheKey);
            }
            if (this.builderData.imageReference.getSourceType().equals((Object)ImageReference.SourceType.VIEW)) {
                profiler.startTask(-2, "wait for view to be measured");
                View v = this.builderData.imageReference.getView();
                this.uiThreadHandler.post((Runnable)new WaitForMeasurement(this.semaphore, v));
                Dali.logV(TAG, "aquire lock for waiting for the view to be measured");
                if (!this.semaphore.tryAcquire(8000L, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Timeout while waiting for the view to be measured");
                }
                Dali.logV(TAG, "view seems measured, lock was released");
                profiler.endTask(-2);
            }
            int width = 0;
            int height = 0;
            if (this.builderData.options.inSampleSize > 1 && this.builderData.rescaleIfDownscaled) {
                profiler.startTask(-1, "measure image");
                Point p = this.builderData.imageReference.measureImage(this.builderData.contextWrapper.getResources());
                width = p.x;
                height = p.y;
                profiler.endTask(-1, height + "x" + width);
            }
            profiler.startTask(0, "load image");
            this.builderData.imageReference.setDecoderOptions(this.builderData.options);
            Bitmap bitmapToWorkWith = this.builderData.imageReference.synchronouslyLoadBitmap(this.builderData.contextWrapper.getResources());
            profiler.endTask(0, "source: " + (Object)((Object)this.builderData.imageReference.getSourceType()) + ", insample: " + this.builderData.options.inSampleSize + ", height:" + bitmapToWorkWith.getHeight() + ", width:" + bitmapToWorkWith.getWidth() + ", memory usage " + BenchmarkUtil.getScalingUnitByteSize(LegacySDKUtil.byteSizeOf(bitmapToWorkWith)));
            if (this.builderData.copyBitmapBeforeBlur) {
                profiler.startTask(1, "copy bitmap");
                bitmapToWorkWith = bitmapToWorkWith.copy(bitmapToWorkWith.getConfig(), true);
                profiler.endTask(1);
            }
            int profileIdPreProcessor = 100;
            for (IBitmapProcessor postProcessor : this.builderData.preProcessors) {
                profiler.startTask(profileIdPreProcessor, postProcessor.getProcessorTag());
                bitmapToWorkWith = postProcessor.manipulate(bitmapToWorkWith);
                profiler.endTask(profileIdPreProcessor++);
            }
            profiler.startTask(10000, "blur with radius " + this.builderData.blurRadius + "px (" + this.builderData.blurRadius * this.builderData.options.inSampleSize + "spx) and algorithm " + this.builderData.blurAlgorithm.getClass().getSimpleName());
            bitmapToWorkWith = this.builderData.blurAlgorithm.blur(this.builderData.blurRadius, bitmapToWorkWith);
            profiler.endTask(10000);
            int profileIdPostProcessor = 20000;
            for (IBitmapProcessor postProcessor : this.builderData.postProcessors) {
                profiler.startTask(profileIdPostProcessor, postProcessor.getProcessorTag());
                bitmapToWorkWith = postProcessor.manipulate(bitmapToWorkWith);
                profiler.endTask(profileIdPostProcessor++);
            }
            if (this.builderData.options.inSampleSize > 1 && this.builderData.rescaleIfDownscaled && height > 0 && width > 0) {
                profiler.startTask(40000, "rescale to " + height + "x" + width);
                bitmapToWorkWith = Bitmap.createScaledBitmap((Bitmap)bitmapToWorkWith, (int)width, (int)height, (boolean)false);
                profiler.endTask(40000, "memory usage " + BenchmarkUtil.getScalingUnitByteSize(LegacySDKUtil.byteSizeOf(bitmapToWorkWith)));
            }
            if (this.builderData.shouldCache) {
                profiler.startTask(40001, "async try to disk cache (ignore result)");
                Dali.getExecutorManager().executeOnFireAndForgetThreadPool(new AddToCacheTask(bitmapToWorkWith, this.builderData, cacheKey));
                profiler.endTask(40001);
            }
            Bitmap bitmap = bitmapToWorkWith;
            return bitmap;
        }
        catch (Throwable t) {
            throw new BlurWorkerException(t);
        }
        finally {
            profiler.printResultToLog();
        }
    }

    public String getId() {
        return this.id;
    }

    public static interface BlurWorkerListener {
        public void onResult(Result var1);
    }

    public static class Result {
        private Bitmap bitmap;
        private Throwable throwable;

        public Result(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        public Result(Throwable t) {
            this.throwable = t;
        }

        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean isError() {
            return this.throwable != null;
        }
    }

    public static class AddToCacheTask
    implements Runnable {
        private Bitmap bitmap;
        private BlurBuilder.BlurData data;
        private String cacheKey;

        public AddToCacheTask(Bitmap bitmap, BlurBuilder.BlurData data, String cacheKey) {
            this.bitmap = bitmap;
            this.data = data;
            this.cacheKey = cacheKey;
        }

        @Override
        public void run() {
            this.data.diskCacheManager.putInCache(this.bitmap, this.cacheKey);
        }
    }

    public static class WaitForMeasurement
    implements Runnable {
        private Semaphore semaphore;
        private View v;

        public WaitForMeasurement(Semaphore semaphore, View v) {
            this.semaphore = semaphore;
            this.v = v;
        }

        @Override
        public void run() {
            this.v.post(new Runnable(){

                @Override
                public void run() {
                    Dali.logV(TAG, "in view message queue, seems measured, will unlock");
                    semaphore.release();
                }
            });
        }
    }
}

