/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.live;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import at.favre.lib.dali.blur.EBlurAlgorithm;
import at.favre.lib.dali.builder.ABuilder;
import at.favre.lib.dali.builder.ContextWrapper;
import at.favre.lib.dali.builder.blur.BlurBuilder;
import at.favre.lib.dali.builder.live.LiveBlurWorker;
import at.favre.lib.dali.util.BuilderUtil;
import java.util.List;

public class LiveBlurBuilder
extends ABuilder {
    private static final String TAG = BlurBuilder.class.getSimpleName();
    private LiveBlurData data = new LiveBlurData();

    public LiveBlurBuilder(ContextWrapper contextWrapper, View rootView, List<View> viewsToBlurOnto) {
        this.data.rootView = rootView;
        this.data.viewsToBlurOnto = viewsToBlurOnto;
        this.data.contextWrapper = contextWrapper;
        this.data.blurAlgorithm = BuilderUtil.getIBlurAlgorithm(EBlurAlgorithm.RS_GAUSS_FAST, contextWrapper);
    }

    public LiveBlurBuilder downScale(int downSampleSize) {
        this.data.downSampleSize = downSampleSize;
        return this;
    }

    public LiveBlurBuilder blurRadius(int blurRadius) {
        BuilderUtil.checkBlurRadiusPrecondition(blurRadius);
        this.data.blurRadius = blurRadius;
        return this;
    }

    public LiveBlurBuilder silentFail() {
        this.data.silentFail = true;
        return this;
    }

    public LiveBlurWorker assemble() {
        return this.assemble(false);
    }

    public LiveBlurWorker assemble(boolean immediatelyBlur) {
        final LiveBlurWorker worker = new LiveBlurWorker(this.data);
        if (immediatelyBlur) {
            Handler handler = new Handler(Looper.getMainLooper());
            for (int i = 1; i < 5; ++i) {
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        worker.updateBlurView();
                    }
                }, (long)(300 * i));
            }
        }
        return worker;
    }

    protected static class LiveBlurData
    extends ABuilder.Data {
        public boolean silentFail = false;
        public int downSampleSize = 8;
        public View rootView;
        public List<View> viewsToBlurOnto;
        public Bitmap.Config config = Bitmap.Config.ARGB_8888;

        protected LiveBlurData() {
        }
    }
}

