/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.live;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import androidx.core.view.ViewCompat;
import at.favre.lib.dali.Dali;
import at.favre.lib.dali.builder.exception.LiveBlurWorkerException;
import at.favre.lib.dali.builder.live.LiveBlurBuilder;
import at.favre.lib.dali.util.BuilderUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class LiveBlurWorker {
    private static final String TAG = LiveBlurWorker.class.getSimpleName();
    private static final int BLUR_ROUNDS_PER_UPDATE = 75;
    private AtomicBoolean isWorking = new AtomicBoolean(false);
    private AtomicInteger blursLeft = new AtomicInteger(0);
    private Bitmap dest;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable blurRunnable = new BlurRunnable();
    private LiveBlurBuilder.LiveBlurData data;

    public LiveBlurWorker(LiveBlurBuilder.LiveBlurData data) {
        this.data = data;
    }

    public boolean updateBlurView() {
        try {
            Dali.logD(TAG, "update");
            if (!BuilderUtil.isOnUiThread()) {
                Dali.logD(TAG, "Not on ui thread");
                return false;
            }
            if (this.data.rootView == null || this.data.viewsToBlurOnto.isEmpty()) {
                Dali.logD(TAG, "Views not set");
                return false;
            }
            if (this.data.viewsToBlurOnto.get(0).getWidth() == 0 || this.data.viewsToBlurOnto.get(0).getHeight() == 0) {
                Dali.logD(TAG, "Views not ready to be blurred");
                return false;
            }
            if (this.blursLeft.get() < 75) {
                this.blursLeft.addAndGet(75);
            }
            if (!this.isWorking.get()) {
                this.handler.post(this.blurRunnable);
                return true;
            }
            Dali.logD(TAG, "Skip blur frame, already in blur");
        }
        catch (Throwable t) {
            this.isWorking.set(false);
            if (this.data.silentFail) {
                Log.e((String)TAG, (String)"Could not create blur view", (Throwable)t);
            }
            throw new LiveBlurWorkerException("Error while updating the live blur", t);
        }
        return false;
    }

    private static Bitmap crop(Bitmap srcBmp, View canvasView, int downsampling) {
        float scale = 1.0f / (float)downsampling;
        return Bitmap.createBitmap((Bitmap)srcBmp, (int)((int)Math.floor(ViewCompat.getX((View)canvasView) * scale)), (int)((int)Math.floor(ViewCompat.getY((View)canvasView) * scale)), (int)((int)Math.floor((float)canvasView.getWidth() * scale)), (int)((int)Math.floor((float)canvasView.getHeight() * scale)));
    }

    private class BlurRunnable
    implements Runnable {
        private BlurRunnable() {
        }

        @Override
        public void run() {
            LiveBlurWorker.this.isWorking.compareAndSet(false, true);
            LiveBlurWorker.this.dest = BuilderUtil.drawViewToBitmap(LiveBlurWorker.this.dest, ((LiveBlurWorker)LiveBlurWorker.this).data.rootView, ((LiveBlurWorker)LiveBlurWorker.this).data.downSampleSize, ((LiveBlurWorker)LiveBlurWorker.this).data.config);
            for (View view : ((LiveBlurWorker)LiveBlurWorker.this).data.viewsToBlurOnto) {
                BitmapDrawable d = new BitmapDrawable(((LiveBlurWorker)LiveBlurWorker.this).data.contextWrapper.getResources(), ((LiveBlurWorker)LiveBlurWorker.this).data.blurAlgorithm.blur(((LiveBlurWorker)LiveBlurWorker.this).data.blurRadius, LiveBlurWorker.crop(LiveBlurWorker.this.dest.copy(LiveBlurWorker.this.dest.getConfig(), true), view, ((LiveBlurWorker)LiveBlurWorker.this).data.downSampleSize)));
                ViewCompat.setBackground((View)view, (Drawable)d);
            }
            int left = LiveBlurWorker.this.blursLeft.decrementAndGet();
            if (left > 0) {
                LiveBlurWorker.this.handler.post((Runnable)this);
            } else {
                LiveBlurWorker.this.isWorking.compareAndSet(true, false);
            }
        }
    }
}

