/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.nav;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.widget.Toolbar;
import androidx.drawerlayout.widget.DrawerLayout;
import at.favre.lib.dali.Dali;
import at.favre.lib.dali.builder.nav.NavigationDrawerListener;
import at.favre.lib.dali.util.BuilderUtil;
import at.favre.lib.dali.util.LegacySDKUtil;

public class DaliBlurDrawerToggle
extends ActionBarDrawerToggle {
    private static String TAG = DaliBlurDrawerToggle.class.getSimpleName();
    private DrawerLayout drawerLayout;
    private Dali dali;
    private ImageView blurView;
    private int blurRadius = 16;
    private int downSample = 4;
    private CacheMode cacheMode = CacheMode.AUTO;
    private boolean forceRedraw = false;
    private boolean enableBlur = true;
    private NavigationDrawerListener listener;

    public DaliBlurDrawerToggle(Activity activity, DrawerLayout drawerLayout, Toolbar toolbar, int openDrawerContentDescRes, int closeDrawerContentDescRes, NavigationDrawerListener listener) {
        super(activity, drawerLayout, toolbar, openDrawerContentDescRes, closeDrawerContentDescRes);
        this.dali = Dali.create(drawerLayout.getContext());
        this.drawerLayout = drawerLayout;
        this.listener = listener;
    }

    public void setConfig(int blurRadius, int downSample, CacheMode cacheMode) {
        BuilderUtil.checkBlurRadiusPrecondition(blurRadius);
        this.blurRadius = blurRadius;
        this.downSample = downSample;
        this.cacheMode = cacheMode;
    }

    public void onDrawerSlide(View drawerView, float slideOffset) {
        super.onDrawerSlide(drawerView, slideOffset);
        this.renderBlurLayer(slideOffset);
    }

    private void renderBlurLayer(float slideOffset) {
        if (this.enableBlur) {
            if (slideOffset == 0.0f || this.forceRedraw) {
                this.clearBlurView();
            }
            if (slideOffset > 0.0f && this.blurView == null) {
                if (this.drawerLayout.getChildCount() == 2) {
                    this.blurView = new ImageView(this.drawerLayout.getContext());
                    this.blurView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    this.blurView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    this.drawerLayout.addView((View)this.blurView, 1);
                }
                if (BuilderUtil.isOnUiThread()) {
                    if (this.cacheMode.equals((Object)CacheMode.AUTO) || this.forceRedraw) {
                        this.dali.load(this.drawerLayout.getChildAt(0)).blurRadius(this.blurRadius).downScale(this.downSample).noFade().error(-1).concurrent().skipCache().into(this.blurView);
                        this.forceRedraw = false;
                    } else {
                        this.dali.load(this.drawerLayout.getChildAt(0)).blurRadius(this.blurRadius).downScale(this.downSample).noFade().error(-1).concurrent().into(this.blurView);
                    }
                }
            }
            if (slideOffset > 0.0f && slideOffset < 1.0f) {
                int alpha = (int)Math.ceil((double)slideOffset * 255.0);
                LegacySDKUtil.setImageAlpha(this.blurView, alpha);
            }
        }
    }

    private void clearBlurView() {
        if (this.drawerLayout.getChildCount() == 3) {
            this.drawerLayout.removeViewAt(1);
        }
        this.blurView = null;
    }

    public void syncState() {
        super.syncState();
        if (this.drawerLayout.isDrawerOpen(0x800003)) {
            this.renderBlurLayer(255.0f);
        } else {
            this.renderBlurLayer(0.0f);
        }
    }

    public void setEnableBlur(boolean enableBlur) {
        this.enableBlur = enableBlur;
    }

    public void setForceRedraw() {
        this.forceRedraw = true;
    }

    public void onDrawerClosed(View view) {
        super.onDrawerClosed(view);
        if (this.listener != null) {
            this.listener.onDrawerOpened(view);
        }
    }

    public void onDrawerOpened(View drawerView) {
        super.onDrawerOpened(drawerView);
        if (this.listener != null) {
            this.listener.onDrawerClosed(drawerView);
        }
    }

    public static enum CacheMode {
        AUTO,
        MANUAL;

    }
}

