/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicConvolve3x3;
import androidx.renderscript.Type;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class BrightnessProcessor
implements IBitmapProcessor {
    private RenderScript rs;
    private float brightness;

    public BrightnessProcessor(RenderScript rs, float brightness) {
        this.rs = rs;
        this.brightness = brightness;
    }

    @Override
    public Bitmap manipulate(Bitmap bitmapOriginal) {
        if (this.brightness != 0.0f) {
            Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)bitmapOriginal);
            Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
            ScriptIntrinsicConvolve3x3 script = ScriptIntrinsicConvolve3x3.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
            script.setCoefficients(this.createBrightnessKernel2(this.brightness));
            script.setInput(input);
            script.forEach(output);
            output.copyTo(bitmapOriginal);
        }
        return bitmapOriginal;
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName() + ": " + this.brightness;
    }

    private float[] createBrightnessKernel(float brightness) {
        float kernelElement = brightness < 0.0f ? 1.0f - Math.abs(brightness) / 100.0f : 1.0f + Math.abs(brightness) / 100.0f;
        kernelElement = Math.max(Math.min(100.0f, kernelElement), 0.0f);
        float[] brightnessKernel = new float[9];
        for (int i = 0; i < 9; ++i) {
            brightnessKernel[i] = i == 4 ? kernelElement : 0.0f;
        }
        return brightnessKernel;
    }

    private float[] createBrightnessKernel2(float brightness) {
        float kernelElement = 0.11111111f;
        kernelElement += kernelElement * (brightness / 100.0f);
        kernelElement = Math.max(Math.min(1.0f, kernelElement), 0.0f);
        float[] brightnessKernel = new float[9];
        for (int i = 0; i < 9; ++i) {
            brightnessKernel[i] = kernelElement;
        }
        return brightnessKernel;
    }
}

