/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class ColorFilterProcessor
implements IBitmapProcessor {
    private int colorResId;
    private PorterDuff.Mode porterDuffMode;

    public ColorFilterProcessor(int colorResId, PorterDuff.Mode porterDuffMode) {
        this.colorResId = colorResId;
        this.porterDuffMode = porterDuffMode;
    }

    @Override
    public Bitmap manipulate(Bitmap original) {
        if (!original.isMutable()) {
            original = original.copy(original.getConfig(), true);
        }
        Paint p = new Paint(this.colorResId);
        PorterDuffColorFilter filter = new PorterDuffColorFilter(this.colorResId, this.porterDuffMode);
        p.setColorFilter((ColorFilter)filter);
        Canvas c = new Canvas(original);
        c.drawBitmap(original, 0.0f, 0.0f, p);
        return original;
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName() + ": " + this.colorResId;
    }
}

