/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.RenderScript;
import androidx.renderscript.Type;
import at.favre.lib.dali.ScriptC_contrast;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class ContrastProcessor
implements IBitmapProcessor {
    private RenderScript rs;
    private float contrast;

    public ContrastProcessor(RenderScript rs, float contrast) {
        this.rs = rs;
        this.contrast = contrast;
    }

    @Override
    public Bitmap manipulate(Bitmap original) {
        if (this.contrast != 0.0f) {
            Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)original);
            Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
            ScriptC_contrast mScript = new ScriptC_contrast(this.rs);
            mScript.invoke_setBright(this.contrast);
            mScript.forEach_contrast(input, output);
            output.copyTo(original);
        }
        return original;
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName() + ": " + this.contrast;
    }
}

