/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicBlend;
import at.favre.lib.dali.R;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class ImageOverlayProcessor
implements IBitmapProcessor {
    private RenderScript rs;
    private Resources res;

    public ImageOverlayProcessor(RenderScript rs, Resources res) {
        this.rs = rs;
        this.res = res;
    }

    @Override
    public Bitmap manipulate(Bitmap original) {
        Allocation input1 = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)original);
        Allocation input2 = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)this.getBlendImage(original));
        ScriptIntrinsicBlend blendScript = ScriptIntrinsicBlend.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        blendScript.forEachSrcOver(input2, input1);
        input1.copyTo(original);
        return original;
    }

    public Bitmap getBlendImage(Bitmap original) {
        Bitmap frost = BitmapFactory.decodeResource((Resources)this.res, (int)R.drawable.frost4);
        return Bitmap.createScaledBitmap((Bitmap)frost, (int)original.getWidth(), (int)original.getHeight(), (boolean)true);
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName();
    }
}

