/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.Matrix4f;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicColorMatrix;
import androidx.renderscript.Type;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class RenderScriptColorFilter
implements IBitmapProcessor {
    private RenderScript rs;
    private float[] data;

    public RenderScriptColorFilter(RenderScript rs, float[] matrix) {
        this.rs = rs;
        this.data = matrix;
    }

    @Override
    public Bitmap manipulate(Bitmap bitmapOriginal) {
        try {
            Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)bitmapOriginal);
            Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
            ScriptIntrinsicColorMatrix mScript = ScriptIntrinsicColorMatrix.create((RenderScript)this.rs, (Element)Element.U8((RenderScript)this.rs));
            Matrix4f matrix4f = new Matrix4f(this.data);
            mScript.setColorMatrix(matrix4f);
            output.copyTo(bitmapOriginal);
        }
        catch (RSRuntimeException rSRuntimeException) {
            // empty catch block
        }
        return bitmapOriginal;
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName() + ": ";
    }
}

