/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.builder.processor;

import android.content.res.Resources;
import android.graphics.Bitmap;
import androidx.renderscript.Allocation;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.Type;
import at.favre.lib.dali.ScriptC_brightness;
import at.favre.lib.dali.builder.processor.IBitmapProcessor;

public class RenderscriptBrightnessProcessor
implements IBitmapProcessor {
    private RenderScript rs;
    private float brightness;
    private Resources res;

    public RenderscriptBrightnessProcessor(RenderScript rs, float brightness, Resources res) {
        this.rs = rs;
        this.brightness = brightness;
        this.res = res;
    }

    @Override
    public Bitmap manipulate(Bitmap bitmapOriginal) {
        if (this.brightness != 0.0f) {
            try {
                Allocation input = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)bitmapOriginal);
                Allocation output = Allocation.createTyped((RenderScript)this.rs, (Type)input.getType());
                ScriptC_brightness mScript = new ScriptC_brightness(this.rs);
                mScript.invoke_setBright(this.brightness);
                mScript.forEach_brightness(input, output);
                output.copyTo(bitmapOriginal);
            }
            catch (RSRuntimeException rSRuntimeException) {
                // empty catch block
            }
        }
        return bitmapOriginal;
    }

    @Override
    public String getProcessorTag() {
        return this.getClass().getSimpleName() + ": " + this.brightness;
    }
}

