/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public final class BitmapUtil {
    private static final String TAG = BitmapUtil.class.getSimpleName();

    private BitmapUtil() {
    }

    public static void clearCacheDir(File cacheDir) {
        File[] files = cacheDir.listFiles();
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    public static Bitmap loadBitmapFromResId(int resId, Resources resources) {
        return BitmapFactory.decodeResource((Resources)resources, (int)resId);
    }

    public static File saveBitmapDownscaled(Bitmap bitmap, String filename, String path, boolean recycle, int maxWidth, int maxHeight) {
        float heightScaleFactor = 1.0f;
        float widthScaleFactor = 1.0f;
        float scaleFactor = 1.0f;
        if (bitmap.getHeight() > maxHeight) {
            heightScaleFactor = (float)maxHeight / (float)bitmap.getHeight();
        }
        if (bitmap.getWidth() > maxWidth) {
            widthScaleFactor = (float)maxWidth / (float)bitmap.getWidth();
        }
        if (heightScaleFactor < 1.0f || widthScaleFactor < 1.0f) {
            scaleFactor = Math.min(heightScaleFactor, widthScaleFactor);
        }
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() * scaleFactor)), (int)((int)((float)bitmap.getHeight() * scaleFactor)), (boolean)true);
        return BitmapUtil.saveBitmap(bitmap, filename, path, recycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBitmap(Bitmap bitmap, String filename, String path, boolean recycle) {
        FileOutputStream out = null;
        try {
            File f = new File(path, filename);
            if (!f.exists()) {
                f.createNewFile();
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)(out = new FileOutputStream(f)))) {
                File file = f;
                return file;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not save bitmap", (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
            if (recycle) {
                bitmap.recycle();
            }
        }
        return null;
    }

    public static Bitmap flip(Bitmap src) {
        Matrix m = new Matrix();
        m.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)m, (boolean)false);
    }

    public static Bitmap changeBitmapContrastBrightness(Bitmap bmp, float contrast, float brightness) {
        ColorMatrix cm = new ColorMatrix(new float[]{contrast, 0.0f, 0.0f, 0.0f, brightness, 0.0f, contrast, 0.0f, 0.0f, brightness, 0.0f, 0.0f, contrast, 0.0f, brightness, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        Bitmap ret = Bitmap.createBitmap((int)bmp.getWidth(), (int)bmp.getHeight(), (Bitmap.Config)bmp.getConfig());
        Canvas canvas = new Canvas(ret);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cm));
        canvas.drawBitmap(bmp, 0.0f, 0.0f, paint);
        return ret;
    }

    public static int getInSampleSizeFromScale(float scale, boolean keepPowOfTwo) {
        int insample = 1;
        for (float scaleThreshold = 1.0f; scaleThreshold >= scale; scaleThreshold /= (float)insample) {
            if (keepPowOfTwo) {
                insample *= 2;
                continue;
            }
            ++insample;
        }
        if (keepPowOfTwo) {
            return insample / 2;
        }
        return insample - 1;
    }
}

