/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.dali.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import android.widget.ImageView;

public final class LegacySDKUtil {
    private LegacySDKUtil() {
    }

    public static float getX(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            return v.getX();
        }
        return v.getLeft();
    }

    public static float getY(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            return v.getY();
        }
        return v.getTop();
    }

    public static void setViewBackground(View v, Drawable d) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(d);
        } else {
            v.setBackgroundDrawable(d);
        }
    }

    public static int byteSizeOf(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static String getBitmapId(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            return String.valueOf(bitmap.getGenerationId());
        }
        return String.valueOf(bitmap.hashCode());
    }

    public static String getCacheDir(Context ctx) {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() && ctx.getExternalCacheDir() != null ? ctx.getExternalCacheDir().getPath() : ctx.getCacheDir().getPath();
    }

    @TargetApi(value=16)
    public static void setImageAlpha(ImageView imageView, int alpha) {
        if (Build.VERSION.SDK_INT >= 18) {
            imageView.setImageAlpha(alpha);
        } else {
            imageView.setAlpha(alpha);
        }
    }
}

